/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.ChatUtil;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TileEntityChatBox
extends TileEntity
implements ITickable,
IPlusPlusPeripheral {
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private static final int TICKER_INTERVAL = 20;
    private int ticker = 0;
    private int subticker = 0;
    private ITurtleAccess turtle;

    public TileEntityChatBox() {
    }

    public TileEntityChatBox(ITurtleAccess turtle) {
        this.func_174878_a(turtle.getPosition());
        this.func_145834_a(turtle.getWorld());
        this.turtle = turtle;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        return nbttagcompound;
    }

    public void func_73660_a() {
        if (this.subticker > 0) {
            --this.subticker;
        }
        if (this.subticker == 0 && this.ticker != 0) {
            this.ticker = 0;
        }
    }

    public void update(boolean turtle) {
        if (turtle) {
            this.func_174878_a(this.turtle.getPosition());
        }
        this.func_73660_a();
    }

    public void onChat(EntityPlayer player, String message) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("chat", new Object[]{player.getDisplayNameString(), message});
        }
    }

    public void onDeath(EntityPlayer player, DamageSource source) {
        Entity ent;
        String killer = null;
        if (source instanceof EntityDamageSource && (ent = source.func_76346_g()) != null) {
            killer = ent.func_70005_c_();
        }
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("death", new Object[]{player.getDisplayNameString(), killer, source.field_76373_n});
        }
    }

    public void onCommand(EntityPlayerMP player, String message) {
        for (IComputerAccess computer : this.computers.keySet()) {
            computer.queueEvent("command", new Object[]{player.getDisplayNameString(), Util.arrayToMap(message.split(" "))});
        }
    }

    public String getType() {
        return "chatBox";
    }

    public String[] getMethodNames() {
        return new String[]{"say", "tell"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (Config.enableChatBox) {
            if (method == 0) {
                if (arguments.length < 1) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Boolean)) {
                    throw new LuaException("Bad argument #3 (expected boolean)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof String)) {
                    throw new LuaException("Bad argument #4 (expected string)");
                }
                if (this.ticker == Config.sayRate) {
                    throw new LuaException("Please try again later, you are sending messages too often");
                }
                String message = Config.logCoords ? ChatUtil.getCoordsPrefix(this) + arguments[0] : (!Config.logCoords && arguments.length > 3 ? "[" + arguments[3] + "] " + arguments[0] : "[@] " + arguments[0]);
                double range = Config.sayRange;
                if (Config.sayRange < 0.0) {
                    range = Double.MAX_VALUE;
                } else if (arguments.length > 1) {
                    if ((Double)arguments[1] < 0.0) {
                        if (Config.sayRange < 0.0) {
                            range = Double.MAX_VALUE;
                        }
                    } else if ((Double)arguments[1] < Config.sayRange) {
                        range = (Double)arguments[1];
                    }
                }
                TileEntityChatBox tileEntityChatBox = this;
                synchronized (tileEntityChatBox) {
                    ChatUtil.sendMessage(this, message, range, arguments.length > 2 && (Boolean)arguments[2] != false && Config.allowUnlimitedVertical);
                    this.subticker = 20;
                    ++this.ticker;
                }
                return new Object[]{true};
            }
            if (method == 1) {
                double range;
                if (arguments.length < 2) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String)) {
                    throw new LuaException("Bad argument #1 (expected string)");
                }
                if (!(arguments[1] instanceof String)) {
                    throw new LuaException("Bad argument #2 (expected string)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                if (arguments.length > 3 && !(arguments[3] instanceof Boolean)) {
                    throw new LuaException("Bad argument #4 (expected boolean)");
                }
                if (arguments.length > 4) {
                    if (Config.logCoords) {
                        throw new LuaException("Coordinate logging is enabled, disable this to enable naming");
                    }
                    if (!(arguments[4] instanceof String)) {
                        throw new LuaException("Bad argument #5 (expected string)");
                    }
                }
                if (this.ticker == Config.sayRate) {
                    throw new LuaException("Please try again later, you are sending messages too often");
                }
                String message = Config.logCoords ? ChatUtil.getCoordsPrefix(this) + arguments[1] : (!Config.logCoords && arguments.length > 4 ? "[" + arguments[4] + "] " + arguments[1] : "[@] " + arguments[1]);
                double d = range = Config.sayRange < 0.0 ? Double.MAX_VALUE : Config.sayRange;
                if (arguments.length > 2) {
                    range = (Double)arguments[2];
                }
                TileEntityChatBox tileEntityChatBox = this;
                synchronized (tileEntityChatBox) {
                    this.subticker = 20;
                    ++this.ticker;
                    ChatUtil.sendMessage((String)arguments[0], this, message, range, arguments.length > 3 && (Boolean)arguments[3] != false && Config.allowUnlimitedVertical);
                }
                return new Object[]{true};
            }
        } else {
            throw new LuaException("Chat boxes have been disabled");
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        if (this.computers.size() == 0) {
            ChatListener.chatBoxMap.put(this, true);
        }
        this.computers.put(computer, true);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        if (this.computers.size() == 0) {
            ChatListener.chatBoxMap.remove(this);
        }
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    public static class ChatListener {
        private static HashMap<TileEntityChatBox, Boolean> chatBoxMap = new HashMap();

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onChat(ServerChatEvent event) {
            block6: {
                if (event.isCanceled() || !Config.enableChatBox) break block6;
                String commandPrefix = Config.chatboxCommandPrefix.trim();
                if (!commandPrefix.equals("") && !commandPrefix.equals(" ") && event.getMessage().startsWith(commandPrefix)) {
                    event.setCanceled(true);
                    for (TileEntityChatBox box : chatBoxMap.keySet()) {
                        if (!(Config.readRange < 0.0)) {
                            Vec3d vec3d = new Vec3d((double)box.func_174877_v().func_177958_n(), (double)box.func_174877_v().func_177956_o(), (double)box.func_174877_v().func_177952_p());
                            if (!(vec3d.func_72438_d(event.getPlayer().func_174791_d()) <= Config.readRange)) continue;
                        }
                        box.onCommand(event.getPlayer(), event.getMessage().replace(commandPrefix, ""));
                    }
                } else {
                    for (TileEntityChatBox box : chatBoxMap.keySet()) {
                        if (!(Config.readRange < 0.0)) {
                            Vec3d vec3d = new Vec3d((Vec3i)box.func_174877_v());
                            if (!(vec3d.func_72438_d(event.getPlayer().func_174791_d()) <= Config.readRange)) continue;
                        }
                        box.onChat((EntityPlayer)event.getPlayer(), event.getMessage());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onDeath(LivingDeathEvent event) {
            if (!event.isCanceled() && Config.enableChatBox && event.getEntity() instanceof EntityPlayer) {
                for (TileEntityChatBox box : chatBoxMap.keySet()) {
                    if (!(Config.readRange < 0.0)) {
                        Vec3d vec3d = new Vec3d((Vec3i)box.func_174877_v());
                        if (!(vec3d.func_72438_d(event.getEntity().func_174791_d()) <= Config.readRange)) continue;
                    }
                    box.onDeath((EntityPlayer)event.getEntity(), event.getSource());
                }
            }
        }
    }
}

