/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.tiles.TileEntityAnalyzer;
import dan200.computercraft.api.peripheral.IPeripheral;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class TileEntityAnalyzerTree
extends TileEntityAnalyzer {
    public String func_70005_c_() {
        return "tileEntityTreeAnalyzer";
    }

    @Override
    public String getType() {
        return "treeAnalyzer";
    }

    @Override
    protected String getRootType() {
        return "rootTrees";
    }

    @Override
    protected void addGenome(ItemStack stack, IGenome origGenome, HashMap<String, Object> ret, boolean activeAllele) {
        ITreeGenome genome = (ITreeGenome)origGenome;
        if (activeAllele) {
            ret.put("speciesPrimary", genome.getPrimary().getAlleleName());
            ret.put("species", genome.getPrimary().getAlleleName());
            ret.put("speciesSecondary", genome.getSecondary().getAlleleName());
            ret.put("height", Float.valueOf(genome.getHeight()));
            ret.put("fertility", Float.valueOf(genome.getFertility()));
            ret.put("yield", Float.valueOf(genome.getYield()));
            ret.put("sappiness", Float.valueOf(genome.getSappiness()));
            ret.put("matures", genome.getMaturationTime());
            ret.put("fruit", genome.getFruitProvider().getDescription());
            ret.put("girth", genome.getGirth());
            ret.put("effect", genome.getEffect().getUID());
            ret.put("decorativeLeaves", genome.getDecorativeLeaves().func_82833_r());
            ret.put("matchesTemplateGenome", genome.matchesTemplateGenome());
        } else {
            ret.put("speciesy", genome.getSecondary().getAlleleName());
            ret.put("height", Float.valueOf(((IAlleleFloat)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT)).getValue()));
            ret.put("fertility", Float.valueOf(((IAlleleFloat)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY)).getValue()));
            ret.put("yield", Float.valueOf(((IAlleleFloat)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.YIELD)).getValue()));
            ret.put("sappiness", Float.valueOf(((IAlleleFloat)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS)).getValue()));
            ret.put("matures", ((IAlleleInteger)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION)).getValue());
            ret.put("fruit", ((IAlleleFruit)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.FRUITS)).getProvider().getDescription());
            ret.put("girth", ((IAlleleInteger)genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.GIRTH)).getValue());
            ret.put("effect", genome.getInactiveAllele((IChromosomeType)EnumTreeChromosome.EFFECT).getUID());
            ret.put("decorativeLeaves", genome.getSecondary().getLeafProvider().getDecorativeLeaves().func_82833_r());
            ret.put("matchesTemplateGenome", this.matchesTemplateGenome(genome.getSecondary(), genome.getChromosomes()));
        }
    }

    private boolean matchesTemplateGenome(IAlleleTreeSpecies alleleTreeSpecies, IChromosome[] chromosomes) {
        IAllele[] template = this.getRoot().getTemplate((IAlleleSpecies)alleleTreeSpecies);
        for (int chromosomeIndex = 0; chromosomeIndex < chromosomes.length; ++chromosomeIndex) {
            IChromosome chromosome = chromosomes[chromosomeIndex];
            String templateUid = template[chromosomeIndex].getUID();
            IAllele primaryAllele = chromosome.getPrimaryAllele();
            if (!primaryAllele.getUID().equals(templateUid)) {
                return false;
            }
            IAllele secondaryAllele = chromosome.getSecondaryAllele();
            if (secondaryAllele.getUID().equals(templateUid)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected IPeripheral getInstance() {
        return this;
    }
}

