/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.tiles.TileEntityAnalyzer;
import com.austinv11.peripheralsplusplus.utils.Util;
import dan200.computercraft.api.peripheral.IPeripheral;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3i;

public class TileEntityAnalyzerBee
extends TileEntityAnalyzer {
    public String func_70005_c_() {
        return "tileEntityBeeAnalyzer";
    }

    @Override
    public String getType() {
        return "beeAnalyzer";
    }

    @Override
    protected String getRootType() {
        return "rootBees";
    }

    @Override
    protected void addGenome(ItemStack stack, IGenome origGenome, HashMap<String, Object> ret, boolean activeAllele) {
        IBeeRoot root = (IBeeRoot)this.getRoot();
        IBeeGenome genome = (IBeeGenome)origGenome;
        ret.put("type", root.getType(stack) == null ? null : root.getType(stack).name());
        if (activeAllele) {
            ret.put("speciesPrimary", genome.getPrimary().getAlleleName());
            ret.put("species", genome.getPrimary().getAlleleName());
            ret.put("speciesSecondary", genome.getSecondary().getAlleleName());
            ret.put("speed", Float.valueOf(genome.getSpeed()));
            ret.put("lifespan", genome.getLifespan());
            ret.put("fertility", genome.getFertility());
            ret.put("neverSleeps", genome.getNeverSleeps());
            ret.put("toleratesRain", genome.getToleratesRain());
            ret.put("caveDwelling", genome.getCaveDwelling());
            ret.put("flower", genome.getFlowerProvider().getDescription());
            ret.put("flowering", genome.getFlowering());
            ret.put("territory", Util.arrayToMap(new int[]{genome.getTerritory().func_177958_n(), genome.getTerritory().func_177956_o(), genome.getTerritory().func_177952_p()}));
            ret.put("effect", genome.getEffect().getUID());
            ret.put("temperature", genome.getPrimary().getTemperature().toString());
            ret.put("toleranceTemperature", genome.getToleranceTemp().toString());
            ret.put("humidity", genome.getPrimary().getHumidity().toString());
            ret.put("toleranceHumidity", genome.getToleranceHumid().toString());
        } else {
            ret.put("species", genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.SPECIES).getAlleleName());
            ret.put("speed", Float.valueOf(((IAlleleFloat)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.SPEED)).getValue()));
            ret.put("lifespan", ((IAlleleInteger)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.LIFESPAN)).getValue());
            ret.put("fertility", ((IAlleleInteger)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.FERTILITY)).getValue());
            ret.put("neverSleeps", ((IAlleleBoolean)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.NEVER_SLEEPS)).getValue());
            ret.put("toleratesRain", ((IAlleleBoolean)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TOLERATES_RAIN)).getValue());
            ret.put("caveDwelling", ((IAlleleBoolean)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.CAVE_DWELLING)).getValue());
            ret.put("flower", ((IAlleleFlowers)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.FLOWER_PROVIDER)).getProvider().getDescription());
            ret.put("flowering", ((IAlleleInteger)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.FLOWERING)).getValue());
            Vec3i territory = ((IAlleleArea)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TERRITORY)).getValue();
            ret.put("territory", Util.arrayToMap(new int[]{territory.func_177958_n(), territory.func_177956_o(), territory.func_177952_p()}));
            ret.put("effect", genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.EFFECT).getUID());
            ret.put("temperature", genome.getSecondary().getTemperature().toString());
            ret.put("toleranceTemperature", ((IAlleleTolerance)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE)).getValue().toString());
            ret.put("humidity", genome.getSecondary().getHumidity().toString());
            ret.put("toleranceHumidity", ((IAlleleTolerance)genome.getInactiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE)).getValue().toString());
        }
    }

    @Override
    protected IPeripheral getInstance() {
        return this;
    }
}

