/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.SynthResponsePacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import com.voicerss.tts.AudioCodec;
import com.voicerss.tts.AudioFormat;
import com.voicerss.tts.VoiceParameters;
import com.voicerss.tts.VoiceProvider;
import dan200.computercraft.api.turtle.TurtleSide;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.nio.file.Paths;
import java.util.UUID;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SynthPacket
implements IMessage {
    private String apiKey;
    private boolean useWebService;
    private UUID eventId;
    private BlockPos pos;
    public String text;
    public String voice;
    public Float pitch;
    public Float pitchRange;
    public Float pitchShift;
    public Float rate;
    public Float volume;
    public TurtleSide side;

    public SynthPacket() {
    }

    public SynthPacket(String text, String voice, Float pitch, Float pitchRange, Float pitchShift, Float rate, Float volume, BlockPos pos, int world, TurtleSide side, UUID eventId, boolean useWebService, String apiKey) {
        this.text = text;
        this.voice = voice;
        this.pitch = pitch;
        this.pitchRange = pitchRange;
        this.pitchShift = pitchShift;
        this.rate = rate;
        this.volume = volume;
        this.pos = pos;
        this.side = side;
        this.eventId = eventId;
        this.useWebService = useWebService;
        this.apiKey = apiKey;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.text = tag.func_74779_i("text");
        this.voice = tag.func_74779_i("voice");
        this.pitch = tag.func_74779_i("pitch").equals("null") ? null : Float.valueOf(Float.parseFloat(tag.func_74779_i("pitch")));
        this.pitchRange = tag.func_74779_i("pitchRange").equals("null") ? null : Float.valueOf(Float.parseFloat(tag.func_74779_i("pitchRange")));
        this.pitchShift = tag.func_74779_i("pitchShift").equals("null") ? null : Float.valueOf(Float.parseFloat(tag.func_74779_i("pitchShift")));
        this.rate = tag.func_74779_i("pitch").equals("null") ? null : Float.valueOf(Float.parseFloat(tag.func_74779_i("pitch")));
        this.volume = tag.func_74779_i("volume").equals("null") ? null : Float.valueOf(Float.parseFloat(tag.func_74779_i("volume")));
        int[] posArray = tag.func_74759_k("pos");
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.side = tag.func_74779_i("side").equals("null") ? null : TurtleSide.valueOf((String)tag.func_74779_i("side"));
        this.eventId = tag.func_186857_a("eventId");
        this.useWebService = tag.func_74767_n("useWebService");
        this.apiKey = tag.func_74779_i("apiKey");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("text", this.text);
        tag.func_74778_a("voice", this.voice);
        tag.func_74778_a("pitch", this.pitch == null ? "null" : this.pitch.toString());
        tag.func_74778_a("pitchRange", this.pitchRange == null ? "null" : this.pitchRange.toString());
        tag.func_74778_a("pitchShift", this.pitchShift == null ? "null" : this.pitchShift.toString());
        tag.func_74778_a("rate", this.rate == null ? "null" : this.rate.toString());
        tag.func_74778_a("volume", this.volume == null ? "null" : this.volume.toString());
        tag.func_74783_a("pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        tag.func_74778_a("side", this.side == null ? "null" : this.side.name());
        tag.func_186854_a("eventId", this.eventId);
        tag.func_74757_a("useWebService", this.useWebService);
        tag.func_74778_a("apiKey", this.apiKey);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class SynthPacketHandler
    implements IMessageHandler<SynthPacket, IMessage> {
        public IMessage onMessage(SynthPacket message, MessageContext ctx) {
            new Thread((Runnable)new SynthThread(message), "PeripheralsPlusOne Synth Thread").start();
            return null;
        }

        private class SynthThread
        implements Runnable {
            private SynthPacket message;

            public SynthThread(SynthPacket message) {
                this.message = message;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean success = false;
                String errorMessage = "";
                if (!this.message.useWebService) {
                    System.setProperty("mbrola.base", Paths.get(Minecraft.func_71410_x().field_71412_D.getAbsolutePath(), "mods/peripheralsplusone/mbrola").toFile().getAbsolutePath());
                    System.setProperty("freetts.voices", "com.sun.speech.freetts.en.us.cmu_us_kal.KevinVoiceDirectory,de.dfki.lt.freetts.en.us.MbrolaVoiceDirectory");
                    try {
                        Voice voice = VoiceManager.getInstance().getVoice(this.message.voice);
                        if (voice != null) {
                            voice.allocate();
                            if (this.message.pitch != null) {
                                voice.setPitch(this.message.pitch.floatValue());
                            }
                            if (this.message.pitchRange != null) {
                                voice.setPitchRange(this.message.pitchRange.floatValue());
                            }
                            if (this.message.pitchShift != null) {
                                voice.setPitchShift(this.message.pitchShift.floatValue());
                            }
                            if (this.message.rate != null) {
                                voice.setRate(this.message.rate.floatValue());
                            }
                            if (this.message.volume != null) {
                                voice.setVolume(this.message.volume.floatValue());
                            }
                            success = voice.speak(this.message.text);
                            voice.deallocate();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errorMessage = e.getMessage();
                    }
                } else {
                    String apiKey = this.message.apiKey;
                    if (apiKey == null || apiKey.isEmpty()) {
                        apiKey = Config.voiceRssApiKey;
                    }
                    if (apiKey != null && !apiKey.isEmpty() && this.message.text != null && !this.message.text.isEmpty() && this.message.voice != null) {
                        VoiceProvider voiceProvider = new VoiceProvider(apiKey);
                        VoiceParameters parameters = new VoiceParameters(this.message.text, this.message.voice);
                        parameters.setCodec(AudioCodec.WAV);
                        parameters.setFormat(AudioFormat.Format_44KHZ.AF_44khz_16bit_stereo);
                        parameters.setBase64(false);
                        parameters.setSSML(false);
                        if (this.message.rate != null) {
                            parameters.setRate(this.message.rate.intValue());
                        }
                        try {
                            byte[] voice = (byte[])voiceProvider.speech(parameters);
                            WaitLineListener lineListener = new WaitLineListener();
                            try (AudioInputStream inputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(voice));
                                 Clip clip = (Clip)AudioSystem.getLine(new DataLine.Info(Clip.class, inputStream.getFormat()));){
                                clip.addLineListener(lineListener);
                                clip.open(inputStream);
                                if (this.message.volume != null && clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                                    ((FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN)).setValue(this.message.volume.floatValue());
                                }
                                clip.start();
                                lineListener.waitUntilDone();
                                success = true;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorMessage = e.getMessage();
                        }
                    }
                }
                SynthThread synthThread = this;
                synchronized (synthThread) {
                    PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new SynthResponsePacket(this.message.text, this.message.pos, (World)Minecraft.func_71410_x().field_71441_e, this.message.side, this.message.eventId, success, errorMessage));
                }
            }

            private class WaitLineListener
            implements LineListener {
                private boolean done = false;

                private WaitLineListener() {
                }

                @Override
                public synchronized void update(LineEvent event) {
                    if (event.getType().equals(LineEvent.Type.STOP) || event.getType().equals(LineEvent.Type.CLOSE)) {
                        this.done = true;
                        this.notifyAll();
                    }
                }

                synchronized void waitUntilDone() throws InterruptedException {
                    while (!this.done) {
                        this.wait();
                    }
                }
            }
        }
    }
}

