/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.mount;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.lua.api.DynApi;
import com.austinv11.peripheralsplusplus.mount.DynamicMountExtra;
import com.austinv11.peripheralsplusplus.mount.DynamicMountFile;
import com.austinv11.peripheralsplusplus.mount.DynamicMountPeripheralChangeListener;
import com.austinv11.peripheralsplusplus.mount.DynamicMountWritable;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import com.austinv11.peripheralsplusplus.utils.proxy.PeripheralChangeListener;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DynamicMount {
    private static List<String> mount(IComputerAccess computer, IPeripheral peripheral) {
        JsonArray index;
        FileReader indexReader;
        ArrayList<String> attached = new ArrayList<String>();
        File mountDirectory = new File(DynamicMount.getMountDirectory(), String.valueOf(computer.getID()));
        File installed = new File(mountDirectory, "installed");
        File installedIndex = new File(installed, "index.json");
        if (!installedIndex.isFile()) {
            return attached;
        }
        try {
            indexReader = new FileReader(installedIndex);
        }
        catch (FileNotFoundException e) {
            return attached;
        }
        try {
            index = new Gson().fromJson((Reader)indexReader, JsonArray.class);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            return attached;
        }
        HashMap<String, File> allExtraFiles = new HashMap<String, File>();
        for (JsonElement programElement : index) {
            JsonObject program;
            JsonElement nameElement;
            if (!(programElement instanceof JsonObject) || !((nameElement = (program = programElement.getAsJsonObject()).get("name")) instanceof JsonPrimitive)) continue;
            String name = nameElement.getAsString();
            JsonElement peripheralsElement = program.get("peripherals");
            if (!(peripheralsElement instanceof JsonArray)) continue;
            JsonArray peripheralsSupported = peripheralsElement.getAsJsonArray();
            JsonElement extraElement = program.get("extra");
            JsonArray extraFiles = new JsonArray();
            if (extraElement instanceof JsonArray) {
                extraFiles = extraElement.getAsJsonArray();
            }
            boolean supported = false;
            for (JsonElement peripheralElement : peripheralsSupported) {
                if (!(peripheralElement instanceof JsonPrimitive)) continue;
                String supportedType = peripheralElement.getAsString();
                String[] peripheralNameSplit = supportedType.split("\\*");
                String peripheralName = peripheral.getType();
                if ((peripheralNameSplit.length != 0 || !peripheralName.equals(supportedType) && !supportedType.equals("*")) && (peripheralNameSplit.length <= 0 || !peripheralName.startsWith(peripheralNameSplit[0]) || peripheralNameSplit.length >= 2 && !peripheralName.endsWith(peripheralNameSplit[1]))) continue;
                supported = true;
                break;
            }
            if (!supported) continue;
            File programDirectory = new File(installed, name);
            File programLua = new File(programDirectory, name + ".lua");
            File programHelp = new File(programDirectory, name + ".txt");
            if (!programLua.isFile()) continue;
            String path = String.format("/rom/programs/%s.lua", name);
            if ((path = computer.mount(path, (IMount)new DynamicMountFile(programLua))) != null) {
                attached.add(path);
            } else {
                PeripheralsPlusPlus.LOGGER.debug(String.format("Failed to mount program \"%s\". The name may be already taken.", name));
            }
            if (programHelp.isFile()) {
                path = String.format("/rom/help/%s.txt", name);
                if ((path = computer.mount(path, (IMount)new DynamicMountFile(programHelp))) != null) {
                    attached.add(path);
                } else {
                    PeripheralsPlusPlus.LOGGER.debug(String.format("Failed to mount help file for program \"%s\".", name));
                }
            }
            for (JsonElement extraFileElement : extraFiles) {
                if (!(extraFileElement instanceof JsonPrimitive)) continue;
                String extraFilePath = extraFileElement.getAsString();
                File extraFile = Paths.get(programDirectory.toString(), "extra", extraFilePath).toFile();
                if (!extraFile.isFile()) continue;
                path = String.format("%s/%s", name, extraFilePath);
                allExtraFiles.put(path, extraFile);
            }
        }
        allExtraFiles.put("dyn/.", installedIndex);
        String path = String.format("/rom/programs/%s", "peripheralsplusone");
        path = computer.mount(path, (IMount)new DynamicMountExtra(allExtraFiles));
        if (path != null) {
            attached.add(path);
        } else {
            PeripheralsPlusPlus.LOGGER.debug("Failed to mount extra files.");
        }
        return attached;
    }

    private static File getMountDirectory() {
        return Paths.get(DimensionManager.getWorld((int)0).func_72860_G().func_75765_b().toString(), "peripheralsplusone", "mount").toFile();
    }

    public static List<String> attach(IComputerAccess computer, IPeripheral peripheral) {
        try {
            Object apiEnvironment = ReflectionHelper.getApiEnvironment(computer.getID());
            if (apiEnvironment != null) {
                ReflectionHelper.registerAPI(computer.getID(), new DynApi(apiEnvironment));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException apiEnvironment) {
            // empty catch block
        }
        ArrayList<String> attached = new ArrayList<String>();
        IMount dynScript = ComputerCraftAPI.createResourceMount(PeripheralsPlusPlus.class, (String)"peripheralsplusone", (String)"lua/mount/dyn.lua");
        IMount dynHelp = ComputerCraftAPI.createResourceMount(PeripheralsPlusPlus.class, (String)"peripheralsplusone", (String)"lua/mount/dyn.txt");
        IMount jsonApi = ComputerCraftAPI.createResourceMount(PeripheralsPlusPlus.class, (String)"peripheralsplusone", (String)"lua/mount/json.lua");
        IMount jsonApiHelp = ComputerCraftAPI.createResourceMount(PeripheralsPlusPlus.class, (String)"peripheralsplusone", (String)"lua/mount/json.txt");
        try {
            String path;
            File mountDirectory;
            String path2;
            if (dynScript != null && (path2 = computer.mount("/rom/programs/dyn.lua", dynScript)) != null) {
                attached.add(path2);
            }
            if (dynHelp != null && (path2 = computer.mount("/rom/help/dyn.txt", dynHelp)) != null) {
                attached.add(path2);
            }
            if (jsonApi != null && (path2 = computer.mount(String.format("/rom/programs/%s/dyn/json.lua", "peripheralsplusone"), jsonApi)) != null) {
                attached.add(path2);
            }
            if (jsonApiHelp != null && (path2 = computer.mount("/rom/help/json.txt", jsonApiHelp)) != null) {
                attached.add(path2);
            }
            if (!(mountDirectory = new File(DynamicMount.getMountDirectory(), String.valueOf(computer.getID()))).exists() && !mountDirectory.mkdirs()) {
                PeripheralsPlusPlus.LOGGER.error("Failed to create mount directory.");
            }
            if ((path = computer.mountWritable("/.peripheralsplusone", (IWritableMount)new DynamicMountWritable(mountDirectory))) != null) {
                attached.add(path);
            }
            attached.addAll(DynamicMount.mount(computer, peripheral));
        }
        catch (RuntimeException e) {
            PeripheralsPlusPlus.LOGGER.error((Object)e);
        }
        return attached;
    }

    public static void detach(IComputerAccess computer, List<String> paths) {
        for (String path : paths) {
            try {
                computer.unmount(path);
            }
            catch (RuntimeException runtimeException) {}
        }
        paths.clear();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient()) {
            return;
        }
        try {
            Collection<Object> computers = ReflectionHelper.getServerComputers();
            for (Object computer : computers) {
                DynamicMountPeripheralChangeListener dynamicMountPeripheralChangeListener;
                Object peripheralChangeListener = ReflectionHelper.getPeripheralChangeListener(computer);
                if (peripheralChangeListener == null || Proxy.isProxyClass(peripheralChangeListener.getClass()) && Proxy.getInvocationHandler(peripheralChangeListener) instanceof PeripheralChangeListener || !(dynamicMountPeripheralChangeListener = new DynamicMountPeripheralChangeListener(computer, peripheralChangeListener)).initializePeripherals()) continue;
                ReflectionHelper.setPeripheralChangeListener(computer, dynamicMountPeripheralChangeListener);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

