/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.event.handler;

import com.austinv11.peripheralsplusplus.network.RobotEventPacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RobotHandler {
    private Robot robot;
    public static CopyOnWriteArrayList<RobotOperation> operationList = new CopyOnWriteArrayList();

    public RobotHandler() {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        this.doOperations();
    }

    private void doOperations() {
        for (RobotOperation operation : operationList) {
            if (operation.isFinished()) {
                operation.onFinish(this.robot);
                operationList.remove(operation);
                continue;
            }
            operation.tick(this.robot);
        }
    }

    public static class MouseMoveOperation
    extends RobotOperation {
        public int x;
        public int y;

        @Override
        public void onFinish(Robot robot) {
        }

        @Override
        public void operate(Robot robot) {
            robot.mouseMove(this.x, this.y);
        }
    }

    public static class MouseClickOperation
    extends RobotOperation {
        public RobotEventPacket.PressType pressType;
        public int button;

        @Override
        public void onFinish(Robot robot) {
            if (this.pressType == RobotEventPacket.PressType.PRESS) {
                try {
                    robot.mouseRelease(InputEvent.getMaskForButton(this.button));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void operate(Robot robot) {
            try {
                robot.mousePress(InputEvent.getMaskForButton(this.button));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public static class KeyBoardOperation
    extends RobotOperation {
        public RobotEventPacket.PressType pressType;
        public String key;

        @Override
        public void onFinish(Robot robot) {
            if (this.pressType == RobotEventPacket.PressType.PRESS) {
                try {
                    robot.keyRelease(this.getKeyField().getInt(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void operate(Robot robot) {
            try {
                robot.keyPress(this.getKeyField().getInt(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public Field getKeyField() {
            try {
                return KeyEvent.class.getField("VK_" + this.key.toUpperCase());
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static abstract class RobotOperation {
        private int ticker;
        private int maxTick;

        public RobotOperation() {
            this.maxTick = this.ticker = Math.round((float)(Config.secondsBeforeReversal * 20.0));
        }

        public boolean isFinished() {
            return this.ticker == 0;
        }

        public void tick(Robot robot) {
            if (this.maxTick == this.ticker) {
                this.operate(robot);
            }
            if (this.ticker != 0) {
                --this.ticker;
            }
        }

        public abstract void onFinish(Robot var1);

        public abstract void operate(Robot var1);
    }
}

