/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice.common.block;

import growthcraft.core.shared.block.BlockPaddyBase;
import growthcraft.rice.shared.init.GrowthcraftRiceItems;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRiceCrop
extends BlockCrops
implements IGrowable,
IPlantable {
    private static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.375, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.6875, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.9375, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.9375, 0.875), new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.875, 0.875)};

    public BlockRiceCrop(String unlocalizedName) {
        this.func_149663_c(unlocalizedName);
        this.setRegistryName("growthcraft_rice", unlocalizedName);
    }

    protected Item func_149866_i() {
        return GrowthcraftRiceItems.rice.getItem();
    }

    protected Item func_149865_P() {
        return GrowthcraftRiceItems.rice.getItem();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)field_176488_a)) {
            case 0: {
                return BOUNDING_BOXES[0];
            }
            case 1: 
            case 2: {
                return BOUNDING_BOXES[1];
            }
            case 3: 
            case 4: {
                return BOUNDING_BOXES[2];
            }
            case 5: 
            case 6: {
                return BOUNDING_BOXES[3];
            }
            case 7: {
                return BOUNDING_BOXES[4];
            }
        }
        return BOUNDING_BOXES[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public void func_176474_b(World worldIn, Random random, BlockPos pos, IBlockState state) {
        this.func_176487_g(worldIn, pos, state);
        BlockPos posDown = pos.func_177977_b();
        IBlockState downBlockState = worldIn.func_180495_p(posDown);
        if (((Boolean)downBlockState.func_177229_b((IProperty)BlockPaddyBase.IS_RADIOACTIVE)).booleanValue()) {
            this.func_176487_g(worldIn, pos, state);
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        BlockPos dwn = pos.func_177977_b();
        IBlockState dwnState = world.func_180495_p(dwn);
        return dwnState.func_177230_c() instanceof BlockPaddyBase;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        BlockPos posDown = pos.func_177977_b();
        IBlockState downBlockState = world.func_180495_p(posDown);
        if (((Boolean)downBlockState.func_177229_b((IProperty)BlockPaddyBase.IS_RADIOACTIVE)).booleanValue()) {
            drops.add((Object)new ItemStack(GrowthcraftRiceItems.rice.getItem()));
        }
    }

    public static class RiceStage {
        public static final int SPROUTING = 0;
        public static final int SPROUT = 1;
        public static final int SAPLING = 2;
        public static final int FLOWERING = 3;
        public static final int MATURE = 4;

        private RiceStage() {
        }
    }
}

