/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.shared.init;

import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.core.shared.definition.IItemStackFactory;
import growthcraft.core.shared.definition.IObjectVariant;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.milk.shared.cheese.CheeseUtils;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseBlockStackFactory;
import growthcraft.milk.shared.definition.ICheeseCurdStackFactory;
import growthcraft.milk.shared.definition.ICheeseFluidStackFactory;
import growthcraft.milk.shared.definition.ICheeseItemStackFactory;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.init.GrowthcraftMilkBlocks;
import growthcraft.milk.shared.init.GrowthcraftMilkFluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GrowthcraftMilkItems {
    public static ItemDefinition stomach;
    public static ItemDefinition thistleSeed;
    public static ItemDefinition thistle;
    public static ItemDefinition cheeseCloth;
    public static ItemDefinition butter;
    public static ItemDefinition iceCream;
    public static ItemDefinition yogurt;
    public static ItemDefinition starterCulture;
    public static ItemDefinition agedCheeseSlice;
    public static ItemDefinition agedCheeseBlockItem;
    public static ItemDefinition waxedCheeseBlockItem;
    public static ItemDefinition waxedCheeseSlice;
    public static ItemDefinition simpleCheeseSlice;
    public static ItemDefinition agedCheeseCurdsItem;
    public static ItemDefinition waxedCheeseCurdsItem;
    public static ItemDefinition simpleCheeseCurdsItem;
    public static ItemTypeDefinition<ItemBoozeBottle> kumisBottle;

    private GrowthcraftMilkItems() {
    }

    private static boolean canWax(WaxedCheeseTypes type, ItemStack stack) {
        String oreName;
        switch (type) {
            case MONTEREY: {
                oreName = "materialBeeswaxBlack";
                break;
            }
            default: {
                oreName = "materialBeeswaxRed";
            }
        }
        int[] oreIDsStack = OreDictionary.getOreIDs((ItemStack)stack);
        int oreIDWax = OreDictionary.getOreID((String)oreName);
        for (int id : oreIDsStack) {
            if (id != oreIDWax) continue;
            return true;
        }
        return false;
    }

    public static enum AgedCheeseTypes implements IStringSerializable,
    ICheeseType,
    IObjectVariant
    {
        GORGONZOLA(0, "gorgonzola", 15394782),
        EMMENTALER(1, "emmentaler", 0xDDDDBC),
        APPENZELLER(2, "appenzeller", 15983271),
        ASIAGO(3, "asiago", 12564109),
        PARMESAN(4, "parmesan", 14210502),
        CASU_MARZU(5, "casu_marzu", 15854034);

        private int ID;
        private ResourceLocation name;
        private int color;

        private AgedCheeseTypes(int id, String name, int color) {
            this.ID = id;
            this.name = new ResourceLocation("growthcraft_milk", name);
            this.color = color;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name.func_110623_a();
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.name;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public boolean canWax(ItemStack stack) {
            return false;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ICheeseItemStackFactory getCheeseItems() {
            return new ICheeseItemStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return agedCheeseSlice.asStack(size, this.getVariantID());
                }
            };
        }

        @Override
        public ICheeseBlockStackFactory getCheeseBlocks() {
            return new ICheeseBlockStackFactory(){

                @Override
                public ItemStack asStackForStage(int size, int slices, EnumCheeseStage stage) {
                    return GrowthcraftMilkBlocks.agedCheeseBlock.asStack(size, CheeseUtils.getItemMetaFor(this, slices, stage));
                }

                @Override
                public EnumCheeseStage getInitialStage() {
                    return EnumCheeseStage.UNAGED;
                }
            };
        }

        @Override
        public ICheeseCurdStackFactory getCurdBlocks() {
            return new ICheeseCurdStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return GrowthcraftMilkBlocks.agedCheeseCurds.asStack(size, CheeseUtils.getItemMetaFor(this, 4, EnumCheeseStage.UNAGED));
                }
            };
        }

        @Override
        public ICheeseFluidStackFactory getFluids() {
            return new ICheeseFluidStackFactory(){

                @Override
                public FluidStack asFluidStack(int amount) {
                    return GrowthcraftMilkFluids.cheesesAged.get(this).asFluidStack(amount);
                }
            };
        }
    }

    public static enum SimpleCheeseTypes implements IStringSerializable,
    ICheeseType,
    IObjectVariant
    {
        RICOTTA(0, "ricotta", 0xC8C8C5);

        private int ID;
        private ResourceLocation name;
        private int color;

        private SimpleCheeseTypes(int id, String name, int color) {
            this.ID = id;
            this.name = new ResourceLocation("growthcraft_milk", name);
            this.color = color;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name.func_110623_a();
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.name;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public boolean canWax(ItemStack stack) {
            return false;
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ICheeseItemStackFactory getCheeseItems() {
            return new ICheeseItemStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return simpleCheeseSlice.asStack(size, this.getVariantID());
                }
            };
        }

        @Override
        public ICheeseBlockStackFactory getCheeseBlocks() {
            return null;
        }

        @Override
        public ICheeseCurdStackFactory getCurdBlocks() {
            return new ICheeseCurdStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return GrowthcraftMilkBlocks.simpleCheeseCurds.asStack(size, CheeseUtils.getItemMetaFor(this, 4, EnumCheeseStage.UNAGED));
                }
            };
        }

        @Override
        public ICheeseFluidStackFactory getFluids() {
            return new ICheeseFluidStackFactory(){

                @Override
                public FluidStack asFluidStack(int amount) {
                    return GrowthcraftMilkFluids.cheesesSimple.get(this).asFluidStack(amount);
                }
            };
        }
    }

    public static enum WaxedCheeseTypes implements ICheeseType,
    IObjectVariant,
    IStringSerializable
    {
        CHEDDAR(0, "cheddar", 15569408),
        MONTEREY(1, "monterey", 16119258),
        GOUDA(2, "gouda", 15654018),
        PROVOLONE(3, "provolone", 0xFFFDD0);

        private int ID;
        private ResourceLocation name;
        private int color;

        private WaxedCheeseTypes(int id, String name, int color) {
            this.ID = id;
            this.name = new ResourceLocation("growthcraft_milk", name);
            this.color = color;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name.func_110623_a();
        }

        @Override
        public ResourceLocation getRegistryName() {
            return this.name;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public boolean canWax(ItemStack stack) {
            return GrowthcraftMilkItems.canWax(this, stack);
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public ICheeseItemStackFactory getCheeseItems() {
            return new ICheeseItemStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return waxedCheeseSlice.asStack(size, this.getVariantID());
                }
            };
        }

        @Override
        public ICheeseBlockStackFactory getCheeseBlocks() {
            return new ICheeseBlockStackFactory(){

                @Override
                public ItemStack asStackForStage(int size, int slices, EnumCheeseStage stage) {
                    return GrowthcraftMilkBlocks.waxedCheeseBlock.asStack(size, CheeseUtils.getItemMetaFor(this, slices, stage));
                }

                @Override
                public EnumCheeseStage getInitialStage() {
                    return EnumCheeseStage.UNWAXED;
                }
            };
        }

        @Override
        public ICheeseCurdStackFactory getCurdBlocks() {
            return new ICheeseCurdStackFactory(){

                @Override
                public ItemStack asStack(int size) {
                    return GrowthcraftMilkBlocks.waxedCheeseCurds.asStack(size, CheeseUtils.getItemMetaFor(this, 4, EnumCheeseStage.UNAGED));
                }
            };
        }

        @Override
        public ICheeseFluidStackFactory getFluids() {
            return new ICheeseFluidStackFactory(){

                @Override
                public FluidStack asFluidStack(int amount) {
                    return GrowthcraftMilkFluids.cheesesWaxed.get(this).asFluidStack(amount);
                }
            };
        }
    }

    public static enum YogurtTypes implements IStringSerializable,
    IObjectVariant,
    IItemStackFactory
    {
        PLAIN(0, "plain"),
        CHOCOLATE(1, "chocolate"),
        GRAPEPURPLE(2, "grape_purple"),
        APPLE(3, "apple"),
        HONEY(4, "honey"),
        WATERMELON(5, "watermelon");

        private int ID;
        private String NAME;

        private YogurtTypes(int id, String name) {
            this.ID = id;
            this.NAME = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.NAME;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public ItemStack asStack(int size) {
            return yogurt.asStack(size, this.getVariantID());
        }

        @Override
        public ItemStack asStack() {
            return this.asStack(1);
        }
    }

    public static enum IceCreamTypes implements IStringSerializable,
    IObjectVariant,
    IItemStackFactory
    {
        PLAIN(0, "plain"),
        CHOCOLATE(1, "chocolate"),
        GRAPEPURPLE(2, "grape_purple"),
        APPLE(3, "apple"),
        HONEY(4, "honey"),
        WATERMELON(5, "watermelon");

        private int ID;
        private String NAME;

        private IceCreamTypes(int id, String name) {
            this.ID = id;
            this.NAME = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.NAME;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public ItemStack asStack(int size) {
            return iceCream.asStack(size, this.getVariantID());
        }

        @Override
        public ItemStack asStack() {
            return this.asStack(1);
        }
    }

    public static enum ButterTypes implements IStringSerializable,
    IObjectVariant,
    IItemStackFactory
    {
        UNSALTED(0, "unsalted"),
        SALTED(1, "salted");

        private int ID;
        private String NAME;

        private ButterTypes(int id, String name) {
            this.ID = id;
            this.NAME = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.NAME;
        }

        @Override
        public int getVariantID() {
            return this.ID;
        }

        @Override
        public ItemStack asStack(int size) {
            return butter.asStack(1, this.getVariantID());
        }

        @Override
        public ItemStack asStack() {
            return this.asStack(1);
        }
    }
}

