/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.struct;

import growthcraft.core.shared.io.stream.IStreamable;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.cheese.CheeseIO;
import growthcraft.milk.shared.config.GrowthcraftMilkConfig;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.init.GrowthcraftMilkItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class Cheese
implements IStreamable {
    public boolean needClientUpdate = true;
    private int ageMax = GrowthcraftMilkConfig.cheeseMaxAge;
    private int age;
    private int slicesMax = 4;
    private int slices = 4;
    private final int cheesePerSlice = GrowthcraftMilkConfig.cheeseItemPerBlockSlice;
    private ICheeseType cheese = GrowthcraftMilkItems.WaxedCheeseTypes.CHEDDAR;
    private EnumCheeseStage cheeseStage = EnumCheeseStage.UNWAXED;

    public ICheeseType getType() {
        return this.cheese;
    }

    public EnumCheeseStage getStage() {
        return this.cheeseStage;
    }

    public Cheese setStage(EnumCheeseStage stage) {
        this.cheeseStage = stage;
        this.needClientUpdate = true;
        return this;
    }

    public int getId() {
        return MilkRegistry.instance().cheese().getCheeseId(this.cheese);
    }

    public int getStageId() {
        return this.cheeseStage.index;
    }

    public int getSlices() {
        return this.slices;
    }

    public int getSlicesMax() {
        return this.slicesMax;
    }

    public boolean hasSlices() {
        return this.getSlices() > 0;
    }

    public float getAgeProgress() {
        return (float)this.age / (float)this.ageMax;
    }

    public boolean canAge() {
        return this.cheeseStage == EnumCheeseStage.UNAGED;
    }

    public boolean isAged() {
        return this.cheeseStage == EnumCheeseStage.AGED || this.cheeseStage == EnumCheeseStage.CUT;
    }

    public boolean isUnwaxed() {
        return this.cheeseStage == EnumCheeseStage.UNWAXED;
    }

    public ItemStack yankSlices(int count, boolean doYank) {
        int yankedCount = MathHelper.func_76125_a((int)count, (int)0, (int)this.getSlices());
        int quantity = yankedCount * this.cheesePerSlice;
        if (quantity > 0) {
            if (doYank) {
                this.slices -= yankedCount;
                this.setStage(EnumCheeseStage.CUT);
            }
            return this.cheese.getCheeseItems().asStack(quantity);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack asFullStack() {
        return this.yankSlices(this.getSlices(), false);
    }

    public boolean tryWaxing(ItemStack stack) {
        if (this.isUnwaxed() && this.getType().canWax(stack)) {
            this.setStage(EnumCheeseStage.UNAGED);
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        CheeseIO.writeToNBT(nbt, this.cheese);
        this.cheeseStage.writeToNBT(nbt);
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("slices", this.slices);
        nbt.func_74768_a("slices_max", this.slicesMax);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.cheese = CheeseIO.loadFromNBT(nbt);
        this.cheeseStage = EnumCheeseStage.loadFromNBT(nbt);
        if (nbt.func_74764_b("age")) {
            this.age = nbt.func_74762_e("age");
        }
        if (nbt.func_74764_b("slices")) {
            this.slices = nbt.func_74762_e("slices");
        }
        if (nbt.func_74764_b("slices_max")) {
            this.slicesMax = nbt.func_74762_e("slices_max");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        this.cheese = CheeseIO.loadFromStream(stream);
        this.cheeseStage = EnumCheeseStage.loadFromStream(stream);
        this.age = stream.readInt();
        this.slices = stream.readInt();
        this.slicesMax = stream.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        CheeseIO.writeToStream(stream, this.cheese);
        this.cheeseStage.writeToStream(stream);
        stream.writeInt(this.age);
        stream.writeInt(this.slices);
        stream.writeInt(this.slicesMax);
        return false;
    }

    public void update() {
        if (!this.isAged() && this.canAge()) {
            if (this.age < this.ageMax) {
                ++this.age;
            } else {
                this.setStage(EnumCheeseStage.AGED);
            }
        }
    }
}

