/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.io.nbt.INBTItemSerializable;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.GrowthcraftTileBase;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.tileentity.struct.Cheese;
import growthcraft.milk.shared.definition.ICheeseBlockStackFactory;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityCheeseBlock
extends GrowthcraftTileBase
implements ITickable,
IItemOperable,
INBTItemSerializable {
    private Cheese cheese = new Cheese();

    public List<ItemStack> populateDrops(List<ItemStack> list) {
        boolean bHasAnySlices;
        ItemStack stack = null;
        boolean bHasAllSlices = this.cheese.getSlicesMax() == this.cheese.getSlices();
        boolean bl = bHasAnySlices = this.cheese.getSlices() > 0;
        if (this.cheese.isAged() && bHasAnySlices) {
            stack = this.cheese.getType().getCheeseBlocks().asStackForStage(this.cheese.getSlices(), this.cheese.getStage());
        } else if (bHasAllSlices) {
            stack = this.cheese.getType().getCheeseBlocks().asStackForStage(this.cheese.getSlices(), this.cheese.getStage());
        }
        if (stack != null) {
            list.add(stack);
        }
        return list;
    }

    public Cheese getCheese() {
        return this.cheese;
    }

    public int getCheeseId() {
        return this.getCheese().getId();
    }

    public int getCheeseStageId() {
        return this.getCheese().getStageId();
    }

    protected void readCheeseFromNBT(NBTTagCompound nbt) {
        this.cheese.readFromNBT(nbt);
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readCheeseFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_CheeseBlock(NBTTagCompound nbt) {
        this.readCheeseFromNBT(nbt);
    }

    protected void writeCheeseToNBT(NBTTagCompound nbt) {
        this.cheese.writeToNBT(nbt);
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeCheeseToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_CheeseBlock(NBTTagCompound nbt) {
        this.writeCheeseToNBT(nbt);
    }

    public ItemStack asItemStack() {
        ICheeseBlockStackFactory blockStackFactory = this.cheese.getType().getCheeseBlocks();
        ItemStack stack = blockStackFactory.asStackForStage(this.cheese.getSlices(), blockStackFactory.getInitialStage());
        NBTTagCompound tag = ItemBlockCheeseBlock.openNBT(stack);
        this.writeToNBTForItem(tag);
        return stack;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.readFromStream(stream);
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_CheeseBlock(ByteBuf stream) throws IOException {
        this.cheese.writeToStream(stream);
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.cheese.update();
            if (this.cheese.needClientUpdate) {
                this.cheese.needClientUpdate = false;
                if (this.cheese.hasSlices()) {
                    this.markForUpdate();
                } else {
                    this.field_145850_b.func_175698_g(this.func_174877_v());
                }
            }
        }
    }

    @Override
    public boolean tryPlaceItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (this.cheese.tryWaxing(onHand)) {
            if (!player.field_71075_bZ.field_75098_d) {
                if (onHand.func_190916_E() > 1) {
                    onHand.func_190918_g(1);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, onHand);
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
            }
            this.markDirtyAndUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        if (this.cheese.isAged()) {
            ItemStack stack = this.cheese.yankSlices(1, true);
            if (!ItemUtils.isEmpty(stack)) {
                ItemUtils.addStackToPlayer(stack, player, false);
            }
            this.markDirtyAndUpdate();
            this.cheese.needClientUpdate |= true;
            return true;
        }
        return false;
    }
}

