/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.inventory.AccesibleSlots;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IItemOperable;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.processing.churn.IChurnRecipe;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityButterChurn
extends GrowthcraftTileDeviceBase
implements IItemOperable {
    private static AccesibleSlots accessibleSlots = new AccesibleSlots(new int[][]{{0}, new int[0], {0}, {0}, {0}, {0}});
    private int shaftState;
    private int churns;
    private DeviceFluidSlot inputFluidSlot = new DeviceFluidSlot(this, 0);
    private DeviceFluidSlot outputFluidSlot = new DeviceFluidSlot(this, 1);
    private DeviceInventorySlot outputInventorySlot = new DeviceInventorySlot((IInventory)this, 0);

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(1000), new FluidTank(1000)};
    }

    public int getShaftState() {
        return this.shaftState;
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 1);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grcmilk.ButterChurn";
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return true;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return accessibleSlots.slotsAt(side);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return accessibleSlots.sideContains(side, index);
    }

    private IChurnRecipe getWorkingRecipe() {
        FluidStack stack = this.inputFluidSlot.get();
        if (stack != null) {
            IChurnRecipe recipe = MilkRegistry.instance().churn().getRecipe(stack);
            return recipe;
        }
        return null;
    }

    public WorkState doWork() {
        WorkState state = WorkState.NONE;
        IChurnRecipe recipe = this.getWorkingRecipe();
        if (recipe != null) {
            state = WorkState.CHURN;
            ++this.churns;
            if (this.churns >= recipe.getChurns()) {
                this.churns = 0;
                this.inputFluidSlot.consume(recipe.getInputFluidStack(), true);
                this.outputFluidSlot.fill(recipe.getOutputFluidStack(), true);
                this.outputInventorySlot.increaseStack(recipe.getOutputItemStack());
                state = WorkState.PRODUCE;
            }
            this.shaftState = this.shaftState == 0 ? 1 : 0;
            this.markForUpdate();
        } else {
            if (this.shaftState != 0) {
                this.shaftState = 0;
                this.markForUpdate();
            }
            this.churns = 0;
        }
        return state;
    }

    private DeviceFluidSlot getActiveFluidSlot() {
        if (this.outputFluidSlot.hasContent()) {
            return this.outputFluidSlot;
        }
        return this.inputFluidSlot;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return MilkRegistry.instance().churn().isFluidIngredient(fluid);
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, int amount, boolean doDrain) {
        return this.getActiveFluidSlot().consume(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, FluidStack stack, boolean doDrain) {
        DeviceFluidSlot fluidSlot = this.getActiveFluidSlot();
        if (FluidTest.areStacksEqual(fluidSlot.get(), stack)) {
            return fluidSlot.consume(stack, doDrain);
        }
        return null;
    }

    @Override
    protected int doFill(EnumFacing dir, FluidStack stack, boolean doFill) {
        int result = 0;
        if (MilkRegistry.instance().churn().isFluidIngredient(stack)) {
            result = this.inputFluidSlot.fill(stack, doFill);
        }
        return result;
    }

    @Override
    public boolean tryPlaceItem(IItemOperable.Action action, EntityPlayer player, ItemStack stack) {
        return false;
    }

    @Override
    public boolean tryTakeItem(IItemOperable.Action action, EntityPlayer player, ItemStack onHand) {
        if (IItemOperable.Action.RIGHT != action) {
            return false;
        }
        ItemStack stack = this.outputInventorySlot.yank();
        if (!ItemUtils.isEmpty(stack)) {
            ItemUtils.addStackToPlayer(stack, player, false);
            return true;
        }
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_ButterChurn(NBTTagCompound nbt) {
        this.shaftState = nbt.func_74762_e("shaft_state");
        this.churns = nbt.func_74762_e("churns");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_ButterChurn(NBTTagCompound nbt) {
        nbt.func_74768_a("shaft_state", this.shaftState);
        nbt.func_74768_a("churns", this.churns);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_ButterChurn(ByteBuf stream) throws IOException {
        this.shaftState = stream.readInt();
        this.churns = stream.readInt();
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_ButterChurn(ByteBuf stream) throws IOException {
        stream.writeInt(this.shaftState);
        stream.writeInt(this.churns);
        return false;
    }

    public static enum WorkState {
        NONE,
        CHURN,
        PRODUCE;

    }
}

