/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.item;

import growthcraft.core.shared.definition.IObjectVariant;
import growthcraft.core.shared.io.nbt.NBTHelper;
import growthcraft.core.shared.item.IItemTileBlock;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.common.item.ItemBlockCheeseBase;
import growthcraft.milk.shared.cheese.CheeseIO;
import growthcraft.milk.shared.cheese.CheeseUtils;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseBlockStackFactory;
import growthcraft.milk.shared.definition.ICheeseType;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockCheeseBlock<T extends ICheeseType & IObjectVariant>
extends ItemBlockCheeseBase<T>
implements IItemTileBlock {
    public ItemBlockCheeseBlock(Block block, T[] typeLookup) {
        super(block, typeLookup);
        this.field_77777_bU = 1;
    }

    private NBTTagCompound getTileTagCompoundABS(ItemStack stack) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        if (!tag.func_74764_b("te_cheese_block")) {
            NBTTagCompound cheeseTag = new NBTTagCompound();
            Object cheese = this.getTypeForVariantID(CheeseUtils.getVariantIDFromMeta(stack.func_77952_i()));
            EnumCheeseStage stage = CheeseUtils.getStageFromMeta(stack.func_77952_i());
            int slices = CheeseUtils.getSlicesFromMeta(stack.func_77952_i());
            CheeseIO.writeToNBT(cheeseTag, cheese);
            stage.writeToNBT(cheeseTag);
            cheeseTag.func_74768_a("slices", slices);
            tag.func_74782_a("te_cheese_block", (NBTBase)cheeseTag);
        }
        return tag.func_74775_l("te_cheese_block");
    }

    @Override
    public void setTileTagCompound(ItemStack stack, NBTTagCompound tileTag) {
        NBTTagCompound tag = NBTHelper.openItemStackTag(stack);
        tag.func_74782_a("te_cheese_block", (NBTBase)tileTag);
    }

    @Override
    public NBTTagCompound getTileTagCompound(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return tag;
    }

    public ICheeseType getCheeseType(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return CheeseIO.loadFromNBT(tag);
    }

    public EnumCheeseStage getCheeseStage(ItemStack stack) {
        NBTTagCompound tag = this.getTileTagCompoundABS(stack);
        return EnumCheeseStage.loadFromNBT(tag);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getCheeseType(stack).getRegistryName().func_110623_a() + "." + this.getCheeseStage(stack).func_176610_l();
    }

    public int getSlices(ItemStack stack) {
        return this.getTileTagCompound(stack).func_74762_e("slices");
    }

    public int getSlicesMax(ItemStack stack) {
        return this.getTileTagCompound(stack).func_74762_e("slices_max");
    }

    public int func_77647_b(int damage) {
        int numSlices = CheeseUtils.getSlicesFromMeta(damage);
        if (numSlices <= 0) {
            GrowthcraftMilk.logger.warn("Cheese item meta returned slicescount=0.");
            numSlices = 1;
        }
        return numSlices - 1 << 2;
    }

    public static NBTTagCompound openNBT(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlockCheeseBlock) {
            return ((ItemBlockCheeseBlock)item).getTileTagCompound(stack);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (ICheeseType type : this.getAllVariants()) {
            ICheeseBlockStackFactory blockStackFactory = type.getCheeseBlocks();
            ItemStack stack = blockStackFactory.asStackForStage(4, blockStackFactory.getInitialStage());
            subItems.add((Object)stack);
        }
    }
}

