/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.utils.BoundUtils;
import growthcraft.milk.common.block.BlockOrientable;
import growthcraft.milk.common.tileentity.TileEntityCheeseBlock;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCheeseBlock
extends BlockOrientable {
    public static final int MAX_VARIANTS = 10;
    public static final PropertyInteger TYPE_SLICES_COUNT = PropertyInteger.func_177719_a((String)"slicescount", (int)0, (int)4);
    public static final PropertyInteger TYPE_CHEESE_VARIANT = PropertyInteger.func_177719_a((String)"typexstage", (int)0, (int)27);
    private static final AxisAlignedBB BOUNDING_BOX_FULL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB BOUNDING_BOX_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5);
    private static final AxisAlignedBB BOUNDING_BOX_4TH = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5);

    public BlockCheeseBlock() {
        super(Material.field_151568_F);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE_SLICES_COUNT, (Comparable)Integer.valueOf(1)));
        this.setTileEntityType(TileEntityCheeseBlock.class);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity(source, pos);
        if (te != null) {
            int numSlices = te.getCheese().getSlices();
            BlockOrientable.Orient orient = (BlockOrientable.Orient)((Object)state.func_177229_b((IProperty)TYPE_ORIENT));
            if (numSlices >= 3) {
                return BOUNDING_BOX_FULL;
            }
            AxisAlignedBB bounds = numSlices >= 2 ? BOUNDING_BOX_HALF : BOUNDING_BOX_4TH;
            return BoundUtils.rotateBlockBounds(bounds, orient.rotationCW);
        }
        return BOUNDING_BOX_FULL;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockCheeseBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    protected boolean shouldRestoreBlockState(World world, BlockPos pos, ItemStack stack) {
        return true;
    }

    @Override
    protected boolean shouldDropTileStack(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return false;
    }

    @Override
    protected ItemStack createHarvestedBlockItemStack(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.asItemStack();
        }
        return new ItemStack((Block)this, 1, this.func_180651_a(state));
    }

    @Override
    protected void getTileItemStackDrops(List<ItemStack> ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity(world, pos);
        if (te != null) {
            ret.add(te.asItemStack());
        } else {
            super.getTileItemStackDrops(ret, world, pos, state, fortune);
        }
    }

    @Override
    protected boolean shouldScatterInventoryOnBreak(World world, BlockPos pos) {
        return true;
    }

    @Override
    protected void scatterInventory(World world, BlockPos pos, Block block) {
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            te.populateDrops(drops);
            for (ItemStack stack : drops) {
                ItemUtils.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack, this.rand);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityCheeseBlock teCheeseBlock = (TileEntityCheeseBlock)this.getTileEntity((IBlockAccess)world, pos);
        if (teCheeseBlock != null) {
            return teCheeseBlock.asItemStack();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity(world, pos);
        if (te != null) {
            te.populateDrops(ret);
        }
        return ret;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ORIENT, TYPE_SLICES_COUNT, TYPE_CHEESE_VARIANT});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int variantID = 0;
        int numSlices = 3;
        TileEntityCheeseBlock te = (TileEntityCheeseBlock)this.getTileEntity(worldIn, pos);
        if (te != null) {
            int effectiveStageId = 0;
            switch (te.getCheese().getStage()) {
                case UNWAXED: {
                    effectiveStageId = 2;
                    break;
                }
                case CUT: 
                case AGED: {
                    effectiveStageId = 1;
                    break;
                }
                default: {
                    effectiveStageId = 0;
                }
            }
            numSlices = te.getCheese().getSlices();
            variantID = effectiveStageId * 10 + te.getCheese().getType().getVariantID();
        }
        return state.func_177226_a((IProperty)TYPE_CHEESE_VARIANT, (Comparable)Integer.valueOf(variantID)).func_177226_a((IProperty)TYPE_SLICES_COUNT, (Comparable)Integer.valueOf(numSlices));
    }
}

