/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common;

import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeRegistryHelper;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.definition.BlockBoozeDefinition;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.cellar.shared.init.GrowthcraftCellarPotions;
import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.utils.BoozeHelper;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.compat.Compat;
import growthcraft.core.shared.config.GrowthcraftCoreConfig;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.effect.EffectExtinguish;
import growthcraft.core.shared.effect.EffectList;
import growthcraft.core.shared.effect.EffectRegistry;
import growthcraft.core.shared.effect.EffectUtils;
import growthcraft.core.shared.fluids.FluidFactory;
import growthcraft.core.shared.fluids.FluidTag;
import growthcraft.core.shared.fluids.GrowthcraftFluid;
import growthcraft.core.shared.fluids.TaggedFluidStacks;
import growthcraft.core.shared.item.CommonItemStackComparator;
import growthcraft.core.shared.item.IItemStackComparator;
import growthcraft.core.shared.item.ItemFoodBottleFluid;
import growthcraft.core.shared.item.OreItemStacks;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import growthcraft.core.shared.utils.TickUtils;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.client.render.RenderButterChurnPlunger;
import growthcraft.milk.client.render.RenderCheesePress;
import growthcraft.milk.client.render.RenderCheeseVat;
import growthcraft.milk.client.render.RenderPancheon;
import growthcraft.milk.common.block.BlockButterChurn;
import growthcraft.milk.common.block.BlockButterChurnPlunger;
import growthcraft.milk.common.block.BlockCheeseBlock;
import growthcraft.milk.common.block.BlockCheesePress;
import growthcraft.milk.common.block.BlockCheeseVat;
import growthcraft.milk.common.block.BlockHangingCurds;
import growthcraft.milk.common.block.BlockPancheon;
import growthcraft.milk.common.block.BlockThistle;
import growthcraft.milk.common.block.fluids.BlockFluidButterMilk;
import growthcraft.milk.common.block.fluids.BlockFluidCheese;
import growthcraft.milk.common.block.fluids.BlockFluidCream;
import growthcraft.milk.common.block.fluids.BlockFluidMilk;
import growthcraft.milk.common.block.fluids.BlockFluidMilkCurds;
import growthcraft.milk.common.block.fluids.BlockFluidPasteurizedMilk;
import growthcraft.milk.common.block.fluids.BlockFluidRennet;
import growthcraft.milk.common.block.fluids.BlockFluidSkimMilk;
import growthcraft.milk.common.block.fluids.BlockFluidWhey;
import growthcraft.milk.common.fluids.FluidButterMilk;
import growthcraft.milk.common.fluids.FluidCheese;
import growthcraft.milk.common.fluids.FluidCream;
import growthcraft.milk.common.fluids.FluidMilk;
import growthcraft.milk.common.fluids.FluidMilkCurds;
import growthcraft.milk.common.fluids.FluidPasteurizedMilk;
import growthcraft.milk.common.fluids.FluidRennet;
import growthcraft.milk.common.fluids.FluidSkimMilk;
import growthcraft.milk.common.fluids.FluidWhey;
import growthcraft.milk.common.item.ItemAgedCheeseSlice;
import growthcraft.milk.common.item.ItemBlockCheeseBlock;
import growthcraft.milk.common.item.ItemBlockHangingCurds;
import growthcraft.milk.common.item.ItemButter;
import growthcraft.milk.common.item.ItemCheeseBowl;
import growthcraft.milk.common.item.ItemCheeseCloth;
import growthcraft.milk.common.item.ItemIceCream;
import growthcraft.milk.common.item.ItemSeedThistle;
import growthcraft.milk.common.item.ItemStarterCulture;
import growthcraft.milk.common.item.ItemStomach;
import growthcraft.milk.common.item.ItemThistle;
import growthcraft.milk.common.item.ItemWaxedCheeseSlice;
import growthcraft.milk.common.item.ItemYogurt;
import growthcraft.milk.common.lib.effect.EffectMilk;
import growthcraft.milk.common.lib.processing.DriedCurdsCheesePressRecipe;
import growthcraft.milk.common.tileentity.TileEntityButterChurn;
import growthcraft.milk.common.tileentity.TileEntityButterChurnPlunger;
import growthcraft.milk.common.tileentity.TileEntityCheeseBlock;
import growthcraft.milk.common.tileentity.TileEntityCheesePress;
import growthcraft.milk.common.tileentity.TileEntityCheeseVat;
import growthcraft.milk.common.tileentity.TileEntityHangingCurds;
import growthcraft.milk.common.tileentity.TileEntityPancheon;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.cheese.CheeseUtils;
import growthcraft.milk.shared.config.GrowthcraftMilkConfig;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseBlockStackFactory;
import growthcraft.milk.shared.definition.ICheeseCurdStackFactory;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.definition.KumisTypes;
import growthcraft.milk.shared.fluids.MilkFluidTags;
import growthcraft.milk.shared.init.GrowthcraftMilkBlocks;
import growthcraft.milk.shared.init.GrowthcraftMilkFluids;
import growthcraft.milk.shared.init.GrowthcraftMilkItems;
import growthcraft.milk.shared.utils.CheeseVatRecipeBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftMilkBlocks.thistle = new BlockDefinition((Block)new BlockThistle("thistle"));
        GrowthcraftMilkBlocks.cheeseVat = new BlockDefinition(new BlockCheeseVat("cheese_vat"));
        if (GrowthcraftMilkFluids.milk != null) {
            GrowthcraftMilkBlocks.blockFluidMilk = GrowthcraftMilkFluids.milk.getFluidBlockDefinition();
        }
        GrowthcraftMilkBlocks.blockFluidRennet = GrowthcraftMilkFluids.rennet.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidButterMilk = GrowthcraftMilkFluids.butterMilk.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidCream = GrowthcraftMilkFluids.cream.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidMilkCurds = GrowthcraftMilkFluids.curds.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidPasteurizedMilk = GrowthcraftMilkFluids.pasteurizedMilk.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidSkimMilk = GrowthcraftMilkFluids.skimMilk.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.blockFluidWhey = GrowthcraftMilkFluids.whey.getFluidBlockDefinition();
        GrowthcraftMilkBlocks.pancheon = new BlockDefinition(new BlockPancheon("pancheon"));
        GrowthcraftMilkBlocks.churn = new BlockDefinition(new BlockButterChurn("churn"));
        GrowthcraftMilkBlocks.churnPlunger = new BlockDefinition(new BlockButterChurnPlunger("churn_plunger"));
        GrowthcraftMilkBlocks.cheesePress = new BlockDefinition(new BlockCheesePress("cheese_press"));
        GrowthcraftMilkBlocks.agedCheeseBlock = new BlockDefinition(new BlockCheeseBlock());
        GrowthcraftMilkBlocks.waxedCheeseBlock = new BlockDefinition(new BlockCheeseBlock());
        GrowthcraftMilkBlocks.agedCheeseCurds = new BlockDefinition(new BlockHangingCurds());
        GrowthcraftMilkBlocks.waxedCheeseCurds = new BlockDefinition(new BlockHangingCurds());
        GrowthcraftMilkBlocks.simpleCheeseCurds = new BlockDefinition(new BlockHangingCurds());
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftMilkBlocks.thistle.registerBlock(registry);
        GrowthcraftMilkBlocks.cheeseVat.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.cheeseVat.registerBlock(registry);
        GrowthcraftMilkBlocks.pancheon.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.pancheon.registerBlock(registry);
        GrowthcraftMilkBlocks.churn.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.churn.registerBlock(registry);
        GrowthcraftMilkBlocks.churnPlunger.registerBlock(registry);
        GrowthcraftMilkBlocks.cheesePress.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.cheesePress.registerBlock(registry);
        GrowthcraftMilkBlocks.agedCheeseBlock.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.agedCheeseBlock.registerBlock(registry, new ResourceLocation("growthcraft_milk", "cheese_aged"));
        GrowthcraftMilkBlocks.waxedCheeseBlock.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.waxedCheeseBlock.registerBlock(registry, new ResourceLocation("growthcraft_milk", "cheese_waxed"));
        GrowthcraftMilkBlocks.agedCheeseCurds.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.agedCheeseCurds.registerBlock(registry, new ResourceLocation("growthcraft_milk", "curds_aged"));
        GrowthcraftMilkBlocks.waxedCheeseCurds.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.waxedCheeseCurds.registerBlock(registry, new ResourceLocation("growthcraft_milk", "curds_waxed"));
        GrowthcraftMilkBlocks.simpleCheeseCurds.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkBlocks.simpleCheeseCurds.registerBlock(registry, new ResourceLocation("growthcraft_milk", "curds_simple"));
    }

    public static void registerBlockItems(IForgeRegistry<Item> registry) {
        GrowthcraftMilkBlocks.cheeseVat.registerBlockItem(registry);
        GrowthcraftMilkBlocks.pancheon.registerBlockItem(registry);
        GrowthcraftMilkBlocks.churn.registerBlockItem(registry);
        GrowthcraftMilkBlocks.cheesePress.registerBlockItem(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenders() {
        GrowthcraftMilkBlocks.thistle.registerItemRender();
        GrowthcraftMilkBlocks.cheeseVat.registerItemRender();
        GrowthcraftMilkBlocks.pancheon.registerItemRender();
        GrowthcraftMilkBlocks.churn.registerItemRender();
        GrowthcraftMilkBlocks.cheesePress.registerItemRender();
    }

    public static void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityPancheon.class, (String)"growthcraft_milk:pancheon");
        GameRegistry.registerTileEntity(TileEntityButterChurn.class, (String)"growthcraft_milk:churn");
        GameRegistry.registerTileEntity(TileEntityButterChurnPlunger.class, (String)"growthcraft_milk:churn_plunger");
        GameRegistry.registerTileEntity(TileEntityCheeseBlock.class, (String)"growthcraft_milk:cheese_block");
        GameRegistry.registerTileEntity(TileEntityHangingCurds.class, (String)"growthcraft_milk:cheese_curds");
        GameRegistry.registerTileEntity(TileEntityCheeseVat.class, (String)"growthcraft_milk:cheese_vat");
        GameRegistry.registerTileEntity(TileEntityCheesePress.class, (String)"growthcraft_milk:cheese_press");
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockSpecialRenders() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPancheon.class, (TileEntitySpecialRenderer)new RenderPancheon());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCheeseVat.class, (TileEntitySpecialRenderer)new RenderCheeseVat());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCheesePress.class, (TileEntitySpecialRenderer)new RenderCheesePress());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityButterChurnPlunger.class, (TileEntitySpecialRenderer)new RenderButterChurnPlunger());
    }

    public static void preInitItems() {
        GrowthcraftMilkItems.thistle = new ItemDefinition(new ItemThistle("thistle"));
        GrowthcraftMilkItems.thistleSeed = new ItemDefinition((Item)new ItemSeedThistle("thistle_seed"));
        GrowthcraftMilkItems.stomach = new ItemDefinition(new ItemStomach("stomach"));
        GrowthcraftMilkItems.cheeseCloth = new ItemDefinition(new ItemCheeseCloth("cheese_cloth"));
        GrowthcraftMilkItems.starterCulture = new ItemDefinition(new ItemStarterCulture("starter_culture"));
        GrowthcraftMilkItems.butter = new ItemDefinition((Item)new ItemButter("butter", 2, 0.3f, false));
        GrowthcraftMilkItems.iceCream = new ItemDefinition((Item)new ItemIceCream("ice_cream", 2, 0.3f, false));
        GrowthcraftMilkItems.yogurt = new ItemDefinition((Item)new ItemYogurt("yogurt", 2, 0.3f, false));
        GrowthcraftMilkItems.agedCheeseSlice = new ItemDefinition((Item)new ItemAgedCheeseSlice("cheese_aged_slice", 2, 0.3f, false));
        GrowthcraftMilkItems.agedCheeseBlockItem = new ItemDefinition((Item)new ItemBlockCheeseBlock(GrowthcraftMilkBlocks.agedCheeseBlock.getBlock(), (ICheeseType[])GrowthcraftMilkItems.AgedCheeseTypes.values()));
        GrowthcraftMilkItems.waxedCheeseBlockItem = new ItemDefinition((Item)new ItemBlockCheeseBlock(GrowthcraftMilkBlocks.waxedCheeseBlock.getBlock(), (ICheeseType[])GrowthcraftMilkItems.WaxedCheeseTypes.values()));
        GrowthcraftMilkItems.waxedCheeseSlice = new ItemDefinition((Item)new ItemWaxedCheeseSlice("cheese_waxed_slice", 2, 0.3f, false));
        GrowthcraftMilkItems.simpleCheeseSlice = new ItemDefinition((Item)new ItemCheeseBowl("cheese_simple_slice", 2, 0.3f, false));
        GrowthcraftMilkItems.agedCheeseCurdsItem = new ItemDefinition((Item)new ItemBlockHangingCurds(GrowthcraftMilkBlocks.agedCheeseCurds.getBlock(), (ICheeseType[])GrowthcraftMilkItems.AgedCheeseTypes.values()));
        GrowthcraftMilkItems.waxedCheeseCurdsItem = new ItemDefinition((Item)new ItemBlockHangingCurds(GrowthcraftMilkBlocks.waxedCheeseCurds.getBlock(), (ICheeseType[])GrowthcraftMilkItems.WaxedCheeseTypes.values()));
        GrowthcraftMilkItems.simpleCheeseCurdsItem = new ItemDefinition((Item)new ItemBlockHangingCurds(GrowthcraftMilkBlocks.simpleCheeseCurds.getBlock(), (ICheeseType[])GrowthcraftMilkItems.SimpleCheeseTypes.values()));
        GrowthcraftMilkItems.kumisBottle = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftMilkItems.thistle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.thistle.registerItem(registry);
        GrowthcraftMilkItems.thistleSeed.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.thistleSeed.registerItem(registry);
        MinecraftForge.addGrassSeed((ItemStack)GrowthcraftMilkItems.thistleSeed.asStack(), (int)1);
        GrowthcraftMilkItems.stomach.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.stomach.registerItem(registry);
        GrowthcraftMilkItems.cheeseCloth.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.cheeseCloth.registerItem(registry);
        GrowthcraftMilkItems.starterCulture.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.starterCulture.registerItem(registry);
        GrowthcraftMilkItems.butter.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.butter.registerItem(registry);
        GrowthcraftMilkItems.iceCream.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.iceCream.registerItem(registry);
        GrowthcraftMilkItems.yogurt.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.yogurt.registerItem(registry);
        GrowthcraftMilkItems.agedCheeseSlice.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.agedCheeseSlice.registerItem(registry);
        GrowthcraftMilkItems.waxedCheeseSlice.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.waxedCheeseSlice.registerItem(registry);
        GrowthcraftMilkItems.simpleCheeseSlice.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.simpleCheeseSlice.registerItem(registry);
        GrowthcraftMilkItems.agedCheeseBlockItem.registerItem(registry, GrowthcraftMilkBlocks.agedCheeseBlock.getBlock().getRegistryName());
        GrowthcraftMilkItems.waxedCheeseBlockItem.registerItem(registry, GrowthcraftMilkBlocks.waxedCheeseBlock.getBlock().getRegistryName());
        GrowthcraftMilkItems.agedCheeseCurdsItem.registerItem(registry, GrowthcraftMilkBlocks.agedCheeseCurds.getBlock().getRegistryName());
        GrowthcraftMilkItems.waxedCheeseCurdsItem.registerItem(registry, GrowthcraftMilkBlocks.waxedCheeseCurds.getBlock().getRegistryName());
        GrowthcraftMilkItems.simpleCheeseCurdsItem.registerItem(registry, GrowthcraftMilkBlocks.simpleCheeseCurds.getBlock().getRegistryName());
        GrowthcraftMilkItems.kumisBottle.registerItem(registry, new ResourceLocation("growthcraft_milk", "kumisbottle"));
        GrowthcraftMilkItems.kumisBottle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftMilkItems.kumisBottle.getItem().setBoozes(GrowthcraftMilkFluids.kumisBooze);
    }

    public static void registerItemOres() {
        for (GrowthcraftMilkItems.IceCreamTypes iceCreamTypes : GrowthcraftMilkItems.IceCreamTypes.values()) {
            OreDictionary.registerOre((String)"foodIceCream", (ItemStack)iceCreamTypes.asStack());
        }
        for (Enum enum_ : GrowthcraftMilkItems.ButterTypes.values()) {
            OreDictionary.registerOre((String)"foodButter", (ItemStack)((GrowthcraftMilkItems.ButterTypes)enum_).asStack());
        }
        for (Enum enum_ : GrowthcraftMilkItems.AgedCheeseTypes.values()) {
            OreDictionary.registerOre((String)"foodCheese", (ItemStack)((GrowthcraftMilkItems.AgedCheeseTypes)enum_).getCheeseItems().asStack());
        }
        for (Enum enum_ : GrowthcraftMilkItems.WaxedCheeseTypes.values()) {
            OreDictionary.registerOre((String)"foodCheese", (ItemStack)((GrowthcraftMilkItems.WaxedCheeseTypes)enum_).getCheeseItems().asStack());
        }
        for (Enum enum_ : GrowthcraftMilkItems.SimpleCheeseTypes.values()) {
            OreDictionary.registerOre((String)"foodCheese", (ItemStack)((GrowthcraftMilkItems.SimpleCheeseTypes)enum_).getCheeseItems().asStack());
        }
        OreDictionary.registerOre((String)"foodYogurt", (ItemStack)GrowthcraftMilkItems.yogurt.asStack());
        OreDictionary.registerOre((String)"materialStomach", (ItemStack)GrowthcraftMilkItems.stomach.asStack());
        OreDictionary.registerOre((String)"rennetSource", GrowthcraftMilkItems.thistle.getItem());
        OreDictionary.registerOre((String)"rennetSource", (ItemStack)GrowthcraftMilkItems.stomach.asStack());
        OreDictionary.registerOre((String)"foodOffal", (ItemStack)GrowthcraftMilkItems.stomach.asStack());
        OreDictionary.registerOre((String)"materialStarterCulture", (ItemStack)GrowthcraftMilkItems.starterCulture.asStack());
        OreDictionary.registerOre((String)"materialCheeseCloth", (ItemStack)GrowthcraftMilkItems.cheeseCloth.asStack());
        OreDictionary.registerOre((String)"listAllsugar", (Item)Items.field_151102_aT);
        OreDictionary.registerOre((String)"foodCocoa", (ItemStack)new ItemStack(Items.field_151100_aR, 1, 3));
        OreDictionary.getOres((String)"foodCocoapowder").forEach(stack -> OreDictionary.registerOre((String)"foodCocoa", (ItemStack)stack));
        if (GrowthcraftMilkItems.thistleSeed != null) {
            OreDictionary.registerOre((String)"listAllseed", (ItemStack)GrowthcraftMilkItems.thistleSeed.asStack());
        }
        OreDictionary.registerOre((String)"foodMelon", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"foodFruit", (Item)Items.field_151127_ba);
        OreDictionary.registerOre((String)"foodChorusFruit", (Item)Items.field_185161_cS);
        OreDictionary.registerOre((String)"foodFruit", (Item)Items.field_185161_cS);
    }

    @SideOnly(value=Side.CLIENT)
    private static <ET extends ICheeseType & IStringSerializable> void registerCheeseWheelItemRenders(ItemDefinition itemDef, ET[] types) {
        for (ET type : types) {
            ICheeseBlockStackFactory blockStackFactory = type.getCheeseBlocks();
            for (EnumCheeseStage stage : EnumCheeseStage.values()) {
                if (blockStackFactory.getInitialStage() != EnumCheeseStage.UNWAXED && stage == EnumCheeseStage.UNWAXED) continue;
                if (stage == EnumCheeseStage.CUT) {
                    for (int i = 1; i <= 4; ++i) {
                        int meta = CheeseUtils.getItemMetaFor(type, i, stage);
                        itemDef.registerRender(meta, ((IStringSerializable)type).func_176610_l() + "_" + stage.func_176610_l());
                    }
                    continue;
                }
                int meta = CheeseUtils.getItemMetaFor(type, 4, stage);
                itemDef.registerRender(meta, ((IStringSerializable)type).func_176610_l() + "_" + stage.func_176610_l());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static <ET extends ICheeseType & IStringSerializable> void registerCheeseCurdsItemRenders(ItemDefinition itemDef, ET[] types) {
        for (ET type : types) {
            int meta = CheeseUtils.getItemMetaFor(type, 4, EnumCheeseStage.UNAGED);
            itemDef.registerRender(meta, ((IStringSerializable)type).func_176610_l() + "_curds");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        GrowthcraftMilkItems.thistle.registerRender();
        GrowthcraftMilkItems.thistleSeed.registerRender();
        GrowthcraftMilkItems.stomach.registerRender();
        GrowthcraftMilkItems.cheeseCloth.registerRender();
        GrowthcraftMilkItems.starterCulture.registerRender();
        GrowthcraftMilkItems.butter.registerRenders(GrowthcraftMilkItems.ButterTypes.class);
        GrowthcraftMilkItems.iceCream.registerRenders(GrowthcraftMilkItems.IceCreamTypes.class);
        GrowthcraftMilkItems.yogurt.registerRenders(GrowthcraftMilkItems.YogurtTypes.class);
        GrowthcraftMilkItems.agedCheeseSlice.registerRenders(GrowthcraftMilkItems.AgedCheeseTypes.class);
        GrowthcraftMilkItems.waxedCheeseSlice.registerRenders(GrowthcraftMilkItems.WaxedCheeseTypes.class);
        GrowthcraftMilkItems.simpleCheeseSlice.registerRenders(GrowthcraftMilkItems.SimpleCheeseTypes.class);
        Init.registerCheeseWheelItemRenders((ItemDefinition)GrowthcraftMilkItems.agedCheeseBlockItem, (ICheeseType[])GrowthcraftMilkItems.AgedCheeseTypes.values());
        Init.registerCheeseWheelItemRenders((ItemDefinition)GrowthcraftMilkItems.waxedCheeseBlockItem, (ICheeseType[])GrowthcraftMilkItems.WaxedCheeseTypes.values());
        Init.registerCheeseCurdsItemRenders((ItemDefinition)GrowthcraftMilkItems.agedCheeseCurdsItem, (ICheeseType[])GrowthcraftMilkItems.AgedCheeseTypes.values());
        Init.registerCheeseCurdsItemRenders((ItemDefinition)GrowthcraftMilkItems.waxedCheeseCurdsItem, (ICheeseType[])GrowthcraftMilkItems.WaxedCheeseTypes.values());
        Init.registerCheeseCurdsItemRenders((ItemDefinition)GrowthcraftMilkItems.simpleCheeseCurdsItem, (ICheeseType[])GrowthcraftMilkItems.SimpleCheeseTypes.values());
        GrowthcraftMilkItems.kumisBottle.registerRenders(KumisTypes.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModelBakeryVariants() {
        GrowthcraftMilkItems.butter.registerModelBakeryVariants(GrowthcraftMilkItems.ButterTypes.class);
        GrowthcraftMilkItems.kumisBottle.registerModelBakeryVariants(KumisTypes.class);
    }

    private static <E extends Enum<?> & IStringSerializable> void preInitCheeseTypes(Map<E, FluidFactory.FluidDetails> fluidMap, Class<E> clazz) {
        Enum[] vals;
        for (Enum type : vals = (Enum[])clazz.getEnumConstants()) {
            String fluidName = "fluid_cheese_" + ((IStringSerializable)type).func_176610_l();
            GrowthcraftFluid cheeseFluid = new FluidCheese(fluidName).setColor(((ICheeseType)((Object)type)).getColor());
            FluidFactory.FluidDetails fluidFactory = new FluidFactory.FluidDetailsBuilder(cheeseFluid, 0).setFluidBlockClass(BlockFluidCheese.class).build().setBlockColor(cheeseFluid.getColor()).setItemColor(cheeseFluid.getColor());
            fluidMap.put(type, fluidFactory);
        }
    }

    private static <E extends Enum<?> & IStringSerializable> void registerCheeseFluidBlocks(IForgeRegistry<Block> registry, Map<E, FluidFactory.FluidDetails> fluidMap) {
        for (Map.Entry<E, FluidFactory.FluidDetails> entry : fluidMap.entrySet()) {
            entry.getValue().registerBlocks(registry, "growthcraft_milk", "cheese_" + ((IStringSerializable)((Enum)entry.getKey())).func_176610_l());
            CoreRegistry.instance().fluidDictionary().addFluidTags(entry.getValue().getFluid(), MilkFluidTags.CHEESE);
        }
    }

    private static <E extends Enum<?> & IStringSerializable> void registerCheeseFluidItems(IForgeRegistry<Item> registry, Map<E, FluidFactory.FluidDetails> fluidMap) {
        for (Map.Entry<E, FluidFactory.FluidDetails> entry : fluidMap.entrySet()) {
            entry.getValue().registerItems(registry, "growthcraft_milk", "cheese_" + ((IStringSerializable)((Enum)entry.getKey())).func_176610_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static <E extends Enum<?> & IStringSerializable> void registerCheeseRenders(Map<E, FluidFactory.FluidDetails> fluidMap) {
        for (Map.Entry<E, FluidFactory.FluidDetails> entry : fluidMap.entrySet()) {
            entry.getValue().registerRenderer();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static <E extends Enum<?> & IStringSerializable> void registerCheeseColorHandlers(Map<E, FluidFactory.FluidDetails> fluidMap) {
        for (Map.Entry<E, FluidFactory.FluidDetails> entry : fluidMap.entrySet()) {
            entry.getValue().registerColorHandlers();
        }
    }

    private static void preInitCheeseFluids() {
        Init.preInitCheeseTypes(GrowthcraftMilkFluids.cheesesSimple, GrowthcraftMilkItems.SimpleCheeseTypes.class);
        Init.preInitCheeseTypes(GrowthcraftMilkFluids.cheesesAged, GrowthcraftMilkItems.AgedCheeseTypes.class);
        Init.preInitCheeseTypes(GrowthcraftMilkFluids.cheesesWaxed, GrowthcraftMilkItems.WaxedCheeseTypes.class);
    }

    public static int roundToBottles(int fluidAmount) {
        int numBottles = fluidAmount / GrowthcraftCoreConfig.bottleCapacity;
        return numBottles * GrowthcraftCoreConfig.bottleCapacity;
    }

    public static void registerFluidOres() {
        if (GrowthcraftMilkFluids.milk != null) {
            OreDictionary.registerOre((String)"bottleMilk", (ItemStack)GrowthcraftMilkFluids.milk.getFoodBottle().asStack());
        }
        OreDictionary.registerOre((String)"bucketMilk", (Item)Items.field_151117_aB);
        if (GrowthcraftMilkFluids.skimMilk != null) {
            OreDictionary.registerOre((String)"bottleSkimmilk", (ItemStack)GrowthcraftMilkFluids.skimMilk.asFoodBottleItemStack());
            OreDictionary.registerOre((String)"bucketSkimmilk", (ItemStack)GrowthcraftMilkFluids.skimMilk.asBucketItemStack());
        }
        if (GrowthcraftMilkFluids.butterMilk != null) {
            OreDictionary.registerOre((String)"bottleButtermilk", (ItemStack)GrowthcraftMilkFluids.butterMilk.asFoodBottleItemStack());
            OreDictionary.registerOre((String)"bucketButtermilk", (ItemStack)GrowthcraftMilkFluids.butterMilk.asBucketItemStack());
        }
        if (GrowthcraftMilkFluids.whey != null) {
            OreDictionary.registerOre((String)"bottleWhey", (ItemStack)GrowthcraftMilkFluids.whey.asFoodBottleItemStack());
            OreDictionary.registerOre((String)"bucketWhey", (ItemStack)GrowthcraftMilkFluids.whey.asBucketItemStack());
            OreDictionary.registerOre((String)"foodStock", (ItemStack)GrowthcraftMilkFluids.whey.asFoodBottleItemStack());
        }
        if (GrowthcraftMilkFluids.cream != null) {
            OreDictionary.registerOre((String)"bottleCream", (ItemStack)GrowthcraftMilkFluids.cream.asBottleItemStack());
            OreDictionary.registerOre((String)"bucketCream", (ItemStack)GrowthcraftMilkFluids.cream.asBucketItemStack());
        }
    }

    public static void preInitFluids() {
        EffectMilk milkEffect = EffectMilk.create(GrowthcraftCellarPotions.potionTipsy);
        if (GrowthcraftMilkConfig.milkEnabled) {
            FluidMilk fluidMilk = new FluidMilk("fluid_milk");
            ItemFoodBottleFluid foodBottleMilk = new ItemFoodBottleFluid(fluidMilk, 4, 0.3f, false);
            foodBottleMilk.setEffect(milkEffect).func_77848_i();
            GrowthcraftMilkFluids.milk = new FluidFactory.FluidDetailsBuilder(fluidMilk, 5).setFluidBlockClass(BlockFluidMilk.class).setFoodBottle(foodBottleMilk).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFFFF);
        }
        FluidButterMilk fluidButterMilk = new FluidButterMilk("fluid_butter_milk");
        ItemFoodBottleFluid foodBottleButterMilk = new ItemFoodBottleFluid(fluidButterMilk, 6, 0.4f, false);
        EffectList list = new EffectList();
        list.add(milkEffect);
        if (GrowthcraftMilkConfig.fantasyMilkEffects) {
            list.add(new EffectExtinguish());
            list.add(EffectUtils.createAddPotionEffect(MobEffects.field_76426_n, TickUtils.seconds(15), 0));
        }
        foodBottleButterMilk.setEffect(list).func_77848_i();
        GrowthcraftMilkFluids.butterMilk = new FluidFactory.FluidDetailsBuilder(fluidButterMilk, 13).setFluidBlockClass(BlockFluidButterMilk.class).setFoodBottle(foodBottleButterMilk).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFEE7);
        FluidCream fluidCream = new FluidCream("fluid_cream");
        GrowthcraftMilkFluids.cream = new FluidFactory.FluidDetailsBuilder(fluidCream).setFluidBlockClass(BlockFluidCream.class).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFDD0);
        FluidMilkCurds fluidMilkCurds = new FluidMilkCurds("fluid_milk_curds");
        GrowthcraftMilkFluids.curds = new FluidFactory.FluidDetailsBuilder(fluidMilkCurds).setFluidBlockClass(BlockFluidMilkCurds.class).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFFF6);
        FluidRennet fluidRennet = new FluidRennet("fluid_rennet");
        GrowthcraftMilkFluids.rennet = new FluidFactory.FluidDetailsBuilder(fluidRennet).setFluidBlockClass(BlockFluidRennet.class).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(8876611);
        FluidSkimMilk fluidSkimMilk = new FluidSkimMilk("fluid_skim_milk");
        ItemFoodBottleFluid foodBottleSkimMilk = new ItemFoodBottleFluid(fluidSkimMilk, 2, 0.2f, false);
        EffectList list2 = new EffectList();
        list2.add(milkEffect);
        if (GrowthcraftMilkConfig.fantasyMilkEffects) {
            list2.add(EffectUtils.createAddPotionEffect(MobEffects.field_76424_c, TickUtils.seconds(15), 0));
        }
        foodBottleSkimMilk.setEffect(list2).func_77848_i();
        GrowthcraftMilkFluids.skimMilk = new FluidFactory.FluidDetailsBuilder(fluidSkimMilk, 13).setFluidBlockClass(BlockFluidSkimMilk.class).setFoodBottle(foodBottleSkimMilk).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFFFA);
        FluidWhey fluidWhey = new FluidWhey("fluid_whey");
        ItemFoodBottleFluid foodBottleWhey = new ItemFoodBottleFluid(fluidWhey, 1, 0.1f, false);
        EffectList list3 = new EffectList();
        if (GrowthcraftMilkConfig.fantasyMilkEffects) {
            list3.add(EffectUtils.createAddPotionEffect(MobEffects.field_76420_g, TickUtils.seconds(10), 0));
            list3.add(EffectUtils.createAddPotionEffect(MobEffects.field_76429_m, TickUtils.seconds(10), 0));
        }
        foodBottleWhey.setEffect(list3).func_77848_i();
        GrowthcraftMilkFluids.whey = new FluidFactory.FluidDetailsBuilder(fluidWhey, 13).setFluidBlockClass(BlockFluidWhey.class).setFoodBottle(foodBottleWhey).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(9742432);
        FluidPasteurizedMilk fluidPasteurizedMilk = new FluidPasteurizedMilk("fluid_pasteurized_milk");
        GrowthcraftMilkFluids.pasteurizedMilk = new FluidFactory.FluidDetailsBuilder(fluidPasteurizedMilk).setFluidBlockClass(BlockFluidPasteurizedMilk.class).build().setCreativeTab(GrowthcraftCoreApis.tabGrowthcraft).setItemColor(0xFFFFFA);
        GrowthcraftMilkFluids.kumisBooze = new BoozeDefinition[KumisTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftMilkFluids.kumisBooze, KumisTypes.class, "kumis");
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_FERMENTED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisFermentedColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisPotentColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_EXTENDED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_HYPEREXTENDED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisHyperExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT_EXTENDED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisPotentExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT_HYPEREXTENDED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisPotentHyperExtendedColor).setDensity(1120);
        ((Booze)GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POISONED.ordinal()].getFluid()).setColor(GrowthcraftMilkConfig.kumisPoisonedColor).setDensity(1120);
        Init.preInitCheeseFluids();
    }

    public static void initFluids() {
        int restCapRounded = Init.roundToBottles(1000 - 2 * GrowthcraftCoreConfig.bottleCapacity);
        List<Fluid> milks = Compat.getMilkFluids();
        for (Fluid f : milks) {
            CoreRegistry.instance().fluidDictionary().addFluidTags(f, MilkFluidTags.MILK);
            MilkRegistry.instance().pancheon().addRecipe(new FluidStack(f, 1000), GrowthcraftMilkFluids.cream.asFluidStack(2 * GrowthcraftCoreConfig.bottleCapacity), GrowthcraftMilkFluids.skimMilk.asFluidStack(restCapRounded), TickUtils.minutes(1));
        }
    }

    public static void registerFluidBlocks(IForgeRegistry<Block> registry) {
        if (GrowthcraftMilkFluids.milk != null) {
            GrowthcraftMilkFluids.milk.registerBlocks(registry, "growthcraft_milk", "milk");
            if (FluidRegistry.getFluid((String)"milk") == null) {
                FluidContainerRegistry.registerFluidContainer(GrowthcraftMilkFluids.milk.getFluid(), new ItemStack(Items.field_151117_aB, 1), new ItemStack(Items.field_151133_ar, 1));
            }
        }
        GrowthcraftMilkFluids.butterMilk.registerBlocks(registry, "growthcraft_milk", "butter_milk");
        GrowthcraftMilkFluids.cream.registerBlocks(registry, "growthcraft_milk", "cream");
        GrowthcraftMilkFluids.curds.registerBlocks(registry, "growthcraft_milk", "milk_curds");
        GrowthcraftMilkFluids.rennet.registerBlocks(registry, "growthcraft_milk", "rennet");
        GrowthcraftMilkFluids.skimMilk.registerBlocks(registry, "growthcraft_milk", "skim_milk");
        GrowthcraftMilkFluids.whey.registerBlocks(registry, "growthcraft_milk", "whey");
        GrowthcraftMilkFluids.pasteurizedMilk.registerBlocks(registry, "growthcraft_milk", "pasteurized_milk");
        CoreRegistry.instance().fluidDictionary().addFluidTags(GrowthcraftMilkFluids.cream.getFluid(), MilkFluidTags.CREAM);
        CoreRegistry.instance().fluidDictionary().addFluidTags(GrowthcraftMilkFluids.curds.getFluid(), MilkFluidTags.MILK_CURDS);
        CoreRegistry.instance().fluidDictionary().addFluidTags(GrowthcraftMilkFluids.rennet.getFluid(), MilkFluidTags.RENNET);
        CoreRegistry.instance().fluidDictionary().addFluidTags(GrowthcraftMilkFluids.whey.getFluid(), MilkFluidTags.WHEY);
        GrowthcraftCellarApis.boozeBuilderFactory.create(GrowthcraftMilkFluids.rennet.getFluid()).brewsFrom(new FluidStack(FluidRegistry.WATER, 1000), new OreItemStacks("rennetSource"), false, TickUtils.minutes(1), null);
        GrowthcraftCellarApis.boozeBuilderFactory.create(GrowthcraftMilkFluids.pasteurizedMilk.getFluid()).brewsFrom(GrowthcraftMilkFluids.skimMilk.asFluidStack(250), new ItemStack(Items.field_151102_aT), false, TickUtils.minutes(1), new Residue(GrowthcraftMilkItems.starterCulture.asStack(1), 1.0f));
        GrowthcraftCellarApis.boozeBuilderFactory.create(GrowthcraftMilkFluids.skimMilk.getFluid()).culturesTo(250, GrowthcraftMilkItems.starterCulture.asStack(), 0.6f, TickUtils.seconds(12));
        GrowthcraftMilk.userApis.churnRecipes.addDefault(GrowthcraftMilkFluids.cream.asFluidStack(Init.roundToBottles(1000)), GrowthcraftMilkFluids.butterMilk.asFluidStack(Init.roundToBottles(500)), GrowthcraftMilkItems.butter.asStack(2), 16);
        Init.registerCheeseFluidBlocks(registry, GrowthcraftMilkFluids.cheesesSimple);
        Init.registerCheeseFluidBlocks(registry, GrowthcraftMilkFluids.cheesesAged);
        Init.registerCheeseFluidBlocks(registry, GrowthcraftMilkFluids.cheesesWaxed);
        GrowthcraftMilkBlocks.kumisFluidBlocks = new BlockBoozeDefinition[GrowthcraftMilkFluids.kumisBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftMilkFluids.kumisBooze, GrowthcraftMilkBlocks.kumisFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftMilkFluids.kumisBooze, 1, -0.3f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftMilkFluids.kumisBooze, GrowthcraftMilkBlocks.kumisFluidBlocks, "growthcraft_milk", "kumisbooze", KumisTypes.class);
    }

    public static void initBoozes() {
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftMilkFluids.kumisBooze, GrowthcraftMilkItems.kumisBottle, "growthcraft_milk", "kumisbooze", KumisTypes.class);
        Init.registerFermentations();
    }

    private static void registerFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = BoozeHelper.boozeDefintionsToFluidStacks(GrowthcraftMilkFluids.kumisBooze);
        FluidStack[] spoilInputFs = BoozeHelper.boozeDefintionsToFluidStacks(GrowthcraftMilkFluids.kumisBooze, 200);
        block8: for (KumisTypes kumisType : KumisTypes.values()) {
            Float fermentOffset = Float.valueOf(1.0f);
            Float alcoholRate = Float.valueOf(0.045f);
            int tipsyDuration = 60;
            Potion potionEffect = MobEffects.field_76429_m;
            int potionDuration = 1;
            switch (kumisType) {
                case KUMIS_FERMENTED: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_FERMENTED.ordinal()].getFluid();
                    FluidStack inputFluid = new FluidStack(FluidRegistry.getFluid((String)"fluid_milk"), 200);
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED};
                    Item inputItem = Items.field_151075_bm;
                    fermentOffset = Float.valueOf(0.66f);
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                case KUMIS_POTENT: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT.ordinal()].getFluid();
                    FluidStack inputFluid = fs[KumisTypes.KUMIS_FERMENTED.ordinal()];
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED, BoozeTag.POTENT};
                    Item inputItem = Items.field_151114_aO;
                    alcoholRate = Float.valueOf(0.09f);
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                case KUMIS_EXTENDED: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_EXTENDED.ordinal()].getFluid();
                    FluidStack inputFluid = fs[KumisTypes.KUMIS_FERMENTED.ordinal()];
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED, BoozeTag.EXTENDED};
                    Item inputItem = Items.field_151137_ax;
                    tipsyDuration = 180;
                    potionDuration = 3;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                case KUMIS_HYPEREXTENDED: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_HYPEREXTENDED.ordinal()].getFluid();
                    FluidStack inputFluid = fs[KumisTypes.KUMIS_EXTENDED.ordinal()];
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED};
                    Item inputItem = Items.field_151137_ax;
                    tipsyDuration = 360;
                    potionDuration = 6;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                case KUMIS_POTENT_EXTENDED: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT_EXTENDED.ordinal()].getFluid();
                    FluidStack inputFluid = fs[KumisTypes.KUMIS_POTENT.ordinal()];
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED, BoozeTag.POTENT, BoozeTag.EXTENDED};
                    Item inputItem = Items.field_151137_ax;
                    alcoholRate = Float.valueOf(0.09f);
                    tipsyDuration = 180;
                    potionDuration = 3;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    inputFluid = fs[KumisTypes.KUMIS_POTENT.ordinal()];
                    inputItem = Items.field_151114_aO;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                case KUMIS_POTENT_HYPEREXTENDED: {
                    Object outputFluid = GrowthcraftMilkFluids.kumisBooze[KumisTypes.KUMIS_POTENT_HYPEREXTENDED.ordinal()].getFluid();
                    FluidStack inputFluid = fs[KumisTypes.KUMIS_POTENT_EXTENDED.ordinal()];
                    FluidTag[] fluidTags = new FluidTag[]{BoozeTag.KUMIS, BoozeTag.FERMENTED, BoozeTag.POTENT, BoozeTag.HYPER_EXTENDED};
                    Item inputItem = Items.field_151137_ax;
                    alcoholRate = Float.valueOf(0.09f);
                    tipsyDuration = 360;
                    potionDuration = 6;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    inputFluid = fs[KumisTypes.KUMIS_HYPEREXTENDED.ordinal()];
                    inputItem = Items.field_151114_aO;
                    Init.registerFermentation(outputFluid, inputFluid, fluidTags, inputItem, (float)fermentTime * fermentOffset.floatValue(), alcoholRate, tipsyDuration, potionEffect, potionDuration);
                    continue block8;
                }
                default: {
                    continue block8;
                }
            }
        }
    }

    public static void registerFermentation(Fluid outputFluid, FluidStack inputFluid, FluidTag[] fluidTags, Item inputItem, float fermentTime, Float alcoholRate, int tipsyDuration, Potion potionEffect, int potionDuration) {
        try {
            GrowthcraftCellarApis.boozeBuilderFactory.create(outputFluid).tags(fluidTags).fermentsFrom(inputFluid, new ItemStack(inputItem), (int)fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(alcoholRate.floatValue()), TickUtils.seconds(tipsyDuration)).addPotionEntry(potionEffect, TickUtils.minutes(potionDuration), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerFluidItems(IForgeRegistry<Item> registry) {
        if (GrowthcraftMilkFluids.milk != null) {
            GrowthcraftMilkFluids.milk.registerItems(registry, "growthcraft_milk", "milk");
        }
        GrowthcraftMilkFluids.butterMilk.registerItems(registry, "growthcraft_milk", "butter_milk");
        GrowthcraftMilkFluids.cream.registerItems(registry, "growthcraft_milk", "cream");
        GrowthcraftMilkFluids.curds.registerItems(registry, "growthcraft_milk", "milk_curds");
        GrowthcraftMilkFluids.rennet.registerItems(registry, "growthcraft_milk", "rennet");
        GrowthcraftMilkFluids.skimMilk.registerItems(registry, "growthcraft_milk", "skim_milk");
        GrowthcraftMilkFluids.whey.registerItems(registry, "growthcraft_milk", "whey");
        GrowthcraftMilkFluids.pasteurizedMilk.registerItems(registry, "growthcraft_milk", "pasteurized_milk");
        Init.registerCheeseFluidItems(registry, GrowthcraftMilkFluids.cheesesSimple);
        Init.registerCheeseFluidItems(registry, GrowthcraftMilkFluids.cheesesAged);
        Init.registerCheeseFluidItems(registry, GrowthcraftMilkFluids.cheesesWaxed);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRenders() {
        if (GrowthcraftMilkFluids.milk != null) {
            GrowthcraftMilkFluids.milk.registerRenderer();
        }
        GrowthcraftMilkFluids.butterMilk.registerRenderer();
        GrowthcraftMilkFluids.cream.registerRenderer();
        GrowthcraftMilkFluids.curds.registerRenderer();
        GrowthcraftMilkFluids.rennet.registerRenderer();
        GrowthcraftMilkFluids.skimMilk.registerRenderer();
        GrowthcraftMilkFluids.whey.registerRenderer();
        GrowthcraftMilkFluids.pasteurizedMilk.registerRenderer();
        Init.registerCheeseRenders(GrowthcraftMilkFluids.cheesesSimple);
        Init.registerCheeseRenders(GrowthcraftMilkFluids.cheesesAged);
        Init.registerCheeseRenders(GrowthcraftMilkFluids.cheesesWaxed);
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftMilkFluids.kumisBooze, GrowthcraftMilkBlocks.kumisFluidBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidColorHandlers() {
        if (GrowthcraftMilkFluids.milk != null) {
            GrowthcraftMilkFluids.milk.registerColorHandlers();
        }
        GrowthcraftMilkFluids.butterMilk.registerColorHandlers();
        GrowthcraftMilkFluids.cream.registerColorHandlers();
        GrowthcraftMilkFluids.curds.registerColorHandlers();
        GrowthcraftMilkFluids.rennet.registerColorHandlers();
        GrowthcraftMilkFluids.skimMilk.registerColorHandlers();
        GrowthcraftMilkFluids.whey.registerColorHandlers();
        GrowthcraftMilkFluids.pasteurizedMilk.registerColorHandlers();
        Init.registerCheeseColorHandlers(GrowthcraftMilkFluids.cheesesSimple);
        Init.registerCheeseColorHandlers(GrowthcraftMilkFluids.cheesesAged);
        Init.registerCheeseColorHandlers(GrowthcraftMilkFluids.cheesesWaxed);
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftMilkItems.kumisBottle.getItem());
    }

    public static void perInitCheese() {
        MilkRegistry.instance().cheese().registerCheeses(GrowthcraftMilkItems.AgedCheeseTypes.class);
        MilkRegistry.instance().cheese().registerCheeses(GrowthcraftMilkItems.SimpleCheeseTypes.class);
        MilkRegistry.instance().cheese().registerCheeses(GrowthcraftMilkItems.WaxedCheeseTypes.class);
    }

    public static void preInitEffects() {
        EffectRegistry reg = CoreRegistry.instance().getEffectsRegistry();
        reg.register("booze_milk", EffectMilk.class);
    }

    private static void registerCheeseVatRecipes() {
        String[] saltOres;
        for (String saltOre : saltOres = new String[]{"salt", "itemSalt", "dustSalt", "foodSalt", "listAllSalt", "ingredientSalt", "pinchSalt", "portionSalt", "lumpSalt", "materialSalt"}) {
            CheeseVatRecipeBuilder.buildRecipe("CHEDDAR Orange Dye Recipe").outputFluids(GrowthcraftMilkItems.WaxedCheeseTypes.CHEDDAR.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeOrange", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("CHEDDAR Pumpkin Recipe").outputFluids(GrowthcraftMilkItems.WaxedCheeseTypes.CHEDDAR.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new ItemStack(Blocks.field_150423_aK)).register();
            CheeseVatRecipeBuilder.buildRecipe("GORGONZOLA Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.GORGONZOLA.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("foodFruit", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("EMMENTALER Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.EMMENTALER.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("cropWheat", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("APPENZELLER Wine Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.APPENZELLER.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds"), new TaggedFluidStacks(1000, "wine")).inputItems(new OreItemStacks(saltOre, 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("APPENZELLER Cider Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.APPENZELLER.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds"), new TaggedFluidStacks(1000, "cider")).inputItems(new OreItemStacks(saltOre, 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("ASIAGO Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.ASIAGO.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks(saltOre, 1), new OreItemStacks("dyeYellow", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("PARMESAN Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.PARMESAN.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeWhite", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("MONTEREY Recipe").outputFluids(GrowthcraftMilkItems.WaxedCheeseTypes.MONTEREY.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeRed", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("PROVOLONE Yellow Dye Recipe").outputFluids(GrowthcraftMilkItems.WaxedCheeseTypes.PROVOLONE.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeYellow", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("GOUDA Recipe").outputFluids(GrowthcraftMilkItems.WaxedCheeseTypes.GOUDA.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("dyeGray", 1), new OreItemStacks("dyeYellow", 1)).register();
            CheeseVatRecipeBuilder.buildRecipe("CASU MARZU Recipe").outputFluids(GrowthcraftMilkItems.AgedCheeseTypes.CASU_MARZU.getFluids().asFluidStack(5000)).inputFluids(new TaggedFluidStacks(5000, "milk_curds")).inputItems(new OreItemStacks(saltOre, 1), new OreItemStacks("listAllfruit", 1), new ItemStack(Items.field_151078_bh)).register();
        }
    }

    public static void registerCraftingRecipes(IForgeRegistry<IRecipe> registry) {
        int ricottaBowlCount = GrowthcraftMilkConfig.ricottaBowlCount;
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("growthcraft_milk", "ricotta"), null, (ItemStack)GrowthcraftMilkItems.SimpleCheeseTypes.RICOTTA.getCheeseItems().asStack(ricottaBowlCount), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)GrowthcraftMilkItems.SimpleCheeseTypes.RICOTTA.getCurdBlocks().asStack().func_77973_b()), Ingredient.func_193367_a((Item)Items.field_151054_z), Ingredient.func_193367_a((Item)Items.field_151054_z), Ingredient.func_193367_a((Item)Items.field_151054_z), Ingredient.func_193367_a((Item)Items.field_151054_z)});
    }

    private static <E extends Enum<?> & IStringSerializable> void registerCheesePressRecipesFor(Class<E> enumType) {
        Enum[] values;
        for (Enum type : values = (Enum[])enumType.getEnumConstants()) {
            ICheeseBlockStackFactory blockFactory = type.getCheeseBlocks();
            ICheeseCurdStackFactory curdsFactory = type.getCurdBlocks();
            if (blockFactory == null || curdsFactory == null) continue;
            MilkRegistry.instance().cheesePress().addRecipe(new DriedCurdsCheesePressRecipe(curdsFactory.asStack(), blockFactory.asStackForStage(4, blockFactory.getInitialStage()), 200));
        }
    }

    private static ResourceLocation toRegName(String name) {
        return new ResourceLocation("growthcraft_milk", name);
    }

    private static void registerCheesePressRecipes() {
        Init.registerCheesePressRecipesFor(GrowthcraftMilkItems.AgedCheeseTypes.class);
        Init.registerCheesePressRecipesFor(GrowthcraftMilkItems.WaxedCheeseTypes.class);
    }

    public static void initRecipes() {
        Init.registerCheeseVatRecipes();
        Init.registerCheesePressRecipes();
    }

    public static class DriedCurdComparator
    implements IItemStackComparator {
        private CommonItemStackComparator common = new CommonItemStackComparator();

        @Override
        public boolean equals(ItemStack expected, ItemStack actual) {
            if (expected.func_77973_b() instanceof ItemBlockHangingCurds) {
                if (actual.func_77973_b() instanceof ItemBlockHangingCurds) {
                    ItemBlockHangingCurds actualCurd = (ItemBlockHangingCurds)actual.func_77973_b();
                    ItemBlockHangingCurds expectedCurd = (ItemBlockHangingCurds)expected.func_77973_b();
                    if (expectedCurd.getCheeseType(expected) == actualCurd.getCheeseType(actual) && actualCurd.isDried(actual)) {
                        return true;
                    }
                }
                return false;
            }
            return this.common.equals(expected, actual);
        }
    }
}

