/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.grapes.common.blocks;

import growthcraft.core.shared.block.BlockCheck;
import growthcraft.grapes.common.blocks.BlockGrapeLeaves;
import growthcraft.grapes.common.blocks.BlockGrapeVineBase;
import growthcraft.grapes.shared.config.GrowthcraftGrapesConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrapeVine1
extends BlockGrapeVineBase {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    public static final int MAX_GROWTH_HEIGHT = 4;
    private final BlockGrapeLeaves blockLeaves;

    public BlockGrapeVine1(BlockGrapeLeaves blockLeaves) {
        this.setGrowthRateMultiplier(GrowthcraftGrapesConfig.grapeVineTrunkGrowthRate);
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.blockLeaves = blockLeaves;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockGrapeVine1.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    @Override
    public int getMaxAge() {
        return 1;
    }

    @Override
    protected boolean canUpdateGrowth(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState stateAbove = world.func_180495_p(pos.func_177984_a());
        int age = this.getAge(state);
        boolean isRopeAbove = BlockCheck.isRope(stateAbove.func_177230_c());
        boolean isLeavesOrRopeAbove = stateAbove.func_177230_c() instanceof BlockGrapeLeaves || isRopeAbove;
        boolean mayGrowHigher = world.func_175623_d(pos.func_177984_a()) && this.canGrowHigher(world, pos, state);
        return age == 0 && isLeavesOrRopeAbove || mayGrowHigher || isRopeAbove;
    }

    public boolean canGrowHigher(World world, BlockPos pos, IBlockState state) {
        for (int i = 1; i < 4; ++i) {
            if (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() instanceof BlockGrapeVine1) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IBlockState doGrowth(World world, BlockPos pos, IBlockState state) {
        IBlockState newState;
        BlockPos posAbove = pos.func_177984_a();
        IBlockState above = world.func_180495_p(posAbove);
        int type = (Integer)state.func_177229_b((IProperty)SUBTYPE);
        if (BlockCheck.isRope(above.func_177230_c())) {
            newState = this.incrementGrowth(world, pos, state);
            world.func_180501_a(posAbove, this.blockLeaves.func_176223_P().func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(type)), 3);
        } else if (world.func_175623_d(posAbove)) {
            if (this.canGrowHigher(world, pos, state)) {
                IBlockState aboveAbove = world.func_180495_p(posAbove.func_177984_a());
                boolean connectToLeaves = aboveAbove.func_177230_c() instanceof BlockGrapeLeaves;
                newState = this.incrementGrowth(world, pos, state);
                world.func_180501_a(posAbove, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(!connectToLeaves ? 0 : this.getMaxAge())).func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(type)), 3);
            } else {
                newState = state;
            }
        } else {
            newState = above.func_177230_c() instanceof BlockGrapeLeaves ? this.incrementGrowth(world, pos, state) : state;
        }
        return newState;
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() instanceof BlockGrapeVine1;
    }

    @Override
    protected float getGrowthRate(World world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177979_c(1)).func_177230_c() == this && world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == Blocks.field_150458_ak) {
            return super.getGrowthRate(world, pos.func_177977_b());
        }
        return super.getGrowthRate(world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos down = pos.func_177977_b();
        return BlockCheck.canSustainPlant((IBlockAccess)worldIn, down, EnumFacing.UP, this) || this == worldIn.func_180495_p(down).func_177230_c();
    }
}

