/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;

public class LootUtils {
    private LootUtils() {
    }

    public static LootPool getOrCreateLootPool(LootTable lootTable, String poolId) {
        LootPool pool = lootTable.getPool(poolId);
        if (pool != null) {
            return pool;
        }
        pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), poolId);
        lootTable.addPool(pool);
        return pool;
    }

    public static void addLootEntry(LootPool pool, Item item, int minCount, int maxCount, int weight) {
        SetCount quantityFct = new SetCount(new LootCondition[0], new RandomValueRange((float)minCount, (float)maxCount));
        pool.addEntry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{quantityFct}, new LootCondition[0], "growthcraft." + item.func_77658_a()));
    }

    public static void addLootEntry(LootPool pool, ItemStack itemStack, int minCount, int maxCount, int weight) {
        SetMetadata metaFct = new SetMetadata(new LootCondition[0], new RandomValueRange((float)itemStack.func_77960_j()));
        SetCount quantityFct = new SetCount(new LootCondition[0], new RandomValueRange((float)minCount, (float)maxCount));
        Item item = itemStack.func_77973_b();
        String name = "growthcraft." + item.func_77658_a() + "." + itemStack.func_77960_j();
        pool.addEntry((LootEntry)new LootEntryItem(item, weight, 0, new LootFunction[]{metaFct, quantityFct}, new LootCondition[0], name));
    }
}

