/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity.device;

import growthcraft.core.shared.fluids.IFluidTanks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DeviceFluidSlot {
    private IFluidTanks tanks;
    private int index;

    public DeviceFluidSlot(IFluidTanks src, int idx) {
        this.tanks = src;
        this.index = idx;
    }

    public FluidStack get() {
        return this.tanks.getFluidStack(this.index);
    }

    public Fluid getFluid() {
        FluidStack stack = this.get();
        if (stack == null) {
            return null;
        }
        return stack.getFluid();
    }

    public int getAmount() {
        FluidStack stack = this.get();
        if (stack == null) {
            return 0;
        }
        return stack.amount;
    }

    public int getCapacity() {
        return this.tanks.getFluidTank(this.index).getCapacity();
    }

    public int getAvailableCapacity() {
        return this.getCapacity() - this.getAmount();
    }

    public void set(FluidStack newStack) {
        this.tanks.setFluidStack(this.index, newStack);
    }

    public void clear() {
        this.tanks.clearTank(this.index);
    }

    public boolean hasContent() {
        return this.tanks.isFluidTankFilled(this.index);
    }

    public boolean isFull() {
        return this.tanks.isFluidTankFull(this.index);
    }

    public boolean isEmpty() {
        return this.tanks.isFluidTankEmpty(this.index);
    }

    public boolean hasMatching(FluidStack stack) {
        FluidStack s = this.get();
        if (stack == null) {
            return s == null;
        }
        if (s != null) {
            return stack.isFluidEqual(s);
        }
        return true;
    }

    public boolean hasMatchingWithCapacity(FluidStack stack) {
        if (!this.isEmpty() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.amount;
    }

    public boolean hasCapacityFor(FluidStack stack) {
        if (this.hasContent() && !this.hasMatching(stack)) {
            return false;
        }
        return this.getAvailableCapacity() >= stack.amount;
    }

    public boolean hasEnough(FluidStack stack) {
        if (!this.hasMatching(stack)) {
            return false;
        }
        FluidStack s = this.get();
        return s.amount >= stack.amount;
    }

    public boolean hasEnough(int amount) {
        return this.getAmount() >= amount;
    }

    public FluidStack consume(int amount, boolean doDrain) {
        return this.tanks.drainFluidTank(this.index, amount, doDrain);
    }

    public FluidStack consume(FluidStack stack, boolean doDrain) {
        if (this.hasMatching(stack)) {
            return this.consume(stack.amount, doDrain);
        }
        return null;
    }

    public int fill(FluidStack fluid, boolean doFill) {
        return this.tanks.fillFluidTank(this.index, fluid, doFill);
    }
}

