/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.tileentity;

import growthcraft.core.shared.fluids.FluidTanks;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.fluids.IFluidTanks;
import growthcraft.core.shared.handlers.FluidHandlerBlockWrapper;
import growthcraft.core.shared.tileentity.GrowthcraftTileInventoryBase;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.IFluidTankOperable;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class GrowthcraftTileDeviceBase
extends GrowthcraftTileInventoryBase
implements IFluidTankOperable,
IFluidTanks {
    private FluidTanks tanks = new FluidTanks(this.createTanks());

    protected void markFluidDirty() {
        this.func_70296_d();
    }

    protected FluidTank[] createTanks() {
        return new FluidTank[0];
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return true;
    }

    protected FluidStack doDrain(EnumFacing dir, int amount, boolean shouldDrain) {
        return null;
    }

    protected FluidStack doDrain(EnumFacing dir, FluidStack stack, boolean shouldDrain) {
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing dir, int amount, boolean shouldDrain) {
        FluidStack result = this.doDrain(dir, amount, shouldDrain);
        if (shouldDrain && FluidTest.isValid(result)) {
            this.markFluidDirty();
        }
        return result;
    }

    @Override
    public FluidStack drain(EnumFacing dir, FluidStack stack, boolean shouldDrain) {
        if (!FluidTest.isValid(stack)) {
            return null;
        }
        FluidStack result = this.doDrain(dir, stack, shouldDrain);
        if (shouldDrain && FluidTest.isValid(result)) {
            this.markFluidDirty();
        }
        return result;
    }

    protected int doFill(EnumFacing dir, FluidStack stack, boolean shouldFill) {
        return 0;
    }

    @Override
    public int fill(EnumFacing dir, FluidStack stack, boolean shouldFill) {
        int result = this.doFill(dir, stack, shouldFill);
        if (shouldFill && result != 0) {
            this.markFluidDirty();
        }
        return result;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tanks.getTankInfo(from);
    }

    @Override
    public IFluidTankProperties[] getTankProperties(EnumFacing from) {
        return this.tanks.getTankProperties(from);
    }

    public IFluidTanks getTanks() {
        return this.tanks;
    }

    @Override
    public int getTankCount() {
        return this.tanks.getTankCount();
    }

    @Override
    public FluidTank[] getFluidTanks() {
        return this.tanks.getFluidTanks();
    }

    @Override
    public int getFluidAmountScaled(int scalar, int slot) {
        return this.tanks.getFluidAmountScaled(scalar, slot);
    }

    @Override
    public float getFluidAmountRate(int slot) {
        return this.tanks.getFluidAmountRate(slot);
    }

    @Override
    public boolean isFluidTankFilled(int slot) {
        return this.tanks.isFluidTankFilled(slot);
    }

    @Override
    public boolean isFluidTankFull(int slot) {
        return this.tanks.isFluidTankFull(slot);
    }

    @Override
    public boolean isFluidTankEmpty(int slot) {
        return this.tanks.isFluidTankEmpty(slot);
    }

    @Override
    public int getFluidAmount(int slot) {
        return this.tanks.getFluidAmount(slot);
    }

    @Override
    public FluidTank getFluidTank(int slot) {
        return this.tanks.getFluidTank(slot);
    }

    @Override
    public FluidStack getFluidStack(int slot) {
        return this.tanks.getFluidStack(slot);
    }

    @Override
    public FluidStack drainFluidTank(int slot, int amount, boolean shouldDrain) {
        FluidStack result = this.tanks.drainFluidTank(slot, amount, shouldDrain);
        if (shouldDrain && FluidTest.isValid(result)) {
            this.markFluidDirty();
        }
        return result;
    }

    @Override
    public int fillFluidTank(int slot, FluidStack fluid, boolean shouldFill) {
        int result = this.tanks.fillFluidTank(slot, fluid, shouldFill);
        if (shouldFill && result != 0) {
            this.markFluidDirty();
        }
        return result;
    }

    @Override
    public void setFluidStack(int slot, FluidStack stack) {
        this.tanks.setFluidStack(slot, stack);
        this.markFluidDirty();
    }

    @Override
    public Fluid getFluid(int slot) {
        return this.tanks.getFluid(slot);
    }

    @Override
    public void clearTank(int slot) {
        this.tanks.clearTank(slot);
        this.markFluidDirty();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                facing = EnumFacing.UP;
            }
            return (T)new FluidHandlerBlockWrapper(this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void readTanksFromNBT(NBTTagCompound nbt) {
        if (this.tanks != null) {
            this.tanks.readFromNBT(nbt);
        }
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.readTanksFromNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_DeviceBase(NBTTagCompound nbt) {
        this.readTanksFromNBT(nbt);
    }

    private void writeTanksToNBT(NBTTagCompound nbt) {
        if (this.tanks != null) {
            this.tanks.writeToNBT(nbt);
        }
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.writeTanksToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_DeviceBase(NBTTagCompound nbt) {
        this.writeTanksToNBT(nbt);
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_FluidTanks(ByteBuf stream) throws IOException {
        if (this.tanks != null) {
            this.tanks.readFromStream(stream);
        }
        return true;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_FluidTanks(ByteBuf stream) throws IOException {
        if (this.tanks != null) {
            this.tanks.writeToStream(stream);
        }
        return false;
    }
}

