/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.io.stream;

import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StreamUtils {
    private StreamUtils() {
    }

    public static String readStringASCII(ByteBuf stream) {
        int len = stream.readInt();
        byte[] bytes = new byte[len];
        try {
            stream.readBytes(bytes);
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static void writeStringASCII(ByteBuf stream, String str) {
        byte[] bytes;
        try {
            bytes = str.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            bytes = str.getBytes();
        }
        stream.writeInt(str.length());
        stream.writeBytes(bytes);
    }

    public static void readFluidTank(ByteBuf stream, FluidTank tank) {
        int capacity = stream.readInt();
        String fluidIdName = StreamUtils.readStringASCII(stream);
        int fluidAmount = stream.readInt();
        Fluid fluid = !fluidIdName.equals("") ? FluidRegistry.getFluid((String)fluidIdName) : null;
        FluidStack fluidStack = fluid != null ? new FluidStack(fluid, fluidAmount) : null;
        tank.setCapacity(capacity);
        tank.setFluid(fluidStack);
    }

    public static void writeFluidTank(ByteBuf stream, FluidTank tank) {
        String fluidIdName = "";
        int fluidAmount = 0;
        int capacity = tank.getCapacity();
        FluidStack fs = tank.getFluid();
        if (fs != null) {
            fluidIdName = fs.getFluid().getName();
            fluidAmount = fs.amount;
        }
        stream.writeInt(capacity);
        StreamUtils.writeStringASCII(stream, fluidIdName);
        stream.writeInt(fluidAmount);
    }
}

