/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config;

public class TagParser {
    public static final TagParser csv = new TagParser();
    public static final TagParser scsv = new TagParser(";");
    public static final TagParser cosv = new TagParser(":");
    private String seperator;

    public TagParser(String sep) {
        this.seperator = sep;
    }

    public TagParser() {
        this(",");
    }

    public String[] parseToArray(String value) {
        String[] strings = value.split(this.seperator);
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public Tag[] parse(String value) {
        String[] strings = this.parseToArray(value);
        Tag[] tags = new Tag[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            tags[i] = Tag.parse(strings[i]);
        }
        return tags;
    }

    public static class Tag {
        public String value;
        public boolean exclude;
        public boolean must;

        public Tag(String val) {
            this.value = val;
        }

        public Tag setExcludeFlag() {
            this.exclude = true;
            return this;
        }

        public Tag setMustFlag() {
            this.must = true;
            return this;
        }

        public String toString() {
            if (this.exclude) {
                return "-" + this.value;
            }
            if (this.must) {
                return "+" + this.value;
            }
            return this.value;
        }

        public static Tag parse(String value) {
            if (value.startsWith("-")) {
                return new Tag(value.substring(1)).setExcludeFlag();
            }
            if (value.startsWith("+")) {
                return new Tag(value.substring(1)).setMustFlag();
            }
            if (value.startsWith("~")) {
                return new Tag(value.substring(1));
            }
            return new Tag(value);
        }
    }
}

