/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core;

import growthcraft.core.common.CommonProxy;
import growthcraft.core.common.Init;
import growthcraft.core.common.creativetabs.TabGrowthcraft;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.compat.Compat;
import growthcraft.core.shared.compat.forestry.InitForestry;
import growthcraft.core.shared.compat.rustic.InitRustic;
import growthcraft.core.shared.config.GrowthcraftCoreConfig;
import growthcraft.core.shared.item.recipes.ShapelessItemComparableRecipe;
import growthcraft.core.shared.item.recipes.ShapelessMultiRecipe;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="growthcraft", name="GrowthcraftCore", version="4.0.4.500", dependencies="after:rustic;after:forestry", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftCore {
    public static final String CLIENT_PROXY_CLASS = "growthcraft.core.client.ClientProxy";
    public static final String SERVER_PROXY_CLASS = "growthcraft.core.common.CommonProxy";
    @Mod.Instance(value="growthcraft")
    public static GrowthcraftCore instance;
    @SidedProxy(serverSide="growthcraft.core.common.CommonProxy", clientSide="growthcraft.core.client.ClientProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        GrowthcraftCoreApis.tabGrowthcraft = new TabGrowthcraft();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GrowthcraftCoreConfig.preInit();
        Init.preInitBlocks();
        Init.preInitItems();
        if (Compat.isModAvailable_Rustic()) {
            InitRustic.preInitBlocks();
            InitRustic.preInitItems();
            InitRustic.preInitFluids();
        }
        if (Compat.isModAvailable_Forestry()) {
            InitForestry.preInitFluids();
        }
        proxy.preInit();
        RecipeSorter.register((String)"minecraft:shapeless_comparator", ShapelessItemComparableRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"minecraft:shapeless_multi", ShapelessMultiRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlockItems((IForgeRegistry<Item>)registry);
        Init.registerItems((IForgeRegistry<Item>)registry);
        proxy.postRegisterItems();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        Init.registerRecipes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        Init.registerBlockOres();
        if (Compat.isModAvailable_Rustic()) {
            InitRustic.registerBlockOres();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Init.registerItemRenders();
        Init.registerBlockRenders();
    }
}

