/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.yeast;

import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.item.ItemKey;
import growthcraft.core.shared.item.WeightedItemStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class YeastRegistry {
    private Set<ItemKey> yeastList = new HashSet<ItemKey>();
    private Map<BiomeDictionary.Type, Set<WeightedItemStack>> biomeTypeToYeast = new HashMap<BiomeDictionary.Type, Set<WeightedItemStack>>();
    private Map<String, Set<WeightedItemStack>> biomeNameToYeast = new HashMap<String, Set<WeightedItemStack>>();
    private Map<ItemKey, Set<BiomeDictionary.Type>> yeastToBiomeType = new HashMap<ItemKey, Set<BiomeDictionary.Type>>();
    private Map<ItemKey, Set<String>> yeastToBiomeName = new HashMap<ItemKey, Set<String>>();

    private ItemKey stackToKey(@Nonnull ItemStack stack) {
        return new ItemKey(stack);
    }

    public void addYeast(@Nonnull ItemStack yeast) {
        this.yeastList.add(this.stackToKey(yeast));
    }

    public boolean isYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return false;
        }
        if (yeast.func_77973_b() == null) {
            return false;
        }
        return this.yeastList.contains(this.stackToKey(yeast));
    }

    public void addYeastToBiomeType(@Nonnull ItemStack yeast, int weight, @Nonnull BiomeDictionary.Type type) {
        ItemKey yeastKey;
        this.addYeast(yeast);
        if (!this.biomeTypeToYeast.containsKey(type)) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Initializing biome type to yeast set for %s", (Object)type);
            this.biomeTypeToYeast.put(type, new HashSet());
        }
        if (!this.yeastToBiomeType.containsKey(yeastKey = this.stackToKey(yeast))) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Initializing yeast to biome type set for %s", (Object)yeast);
            this.yeastToBiomeType.put(yeastKey, new HashSet());
        }
        this.biomeTypeToYeast.get(type).add(new WeightedItemStack(weight, yeast));
        this.yeastToBiomeType.get(yeastKey).add(type);
    }

    public void addYeastToBiomeByName(@Nonnull ItemStack yeast, int weight, @Nonnull String name) {
        this.addYeast(yeast);
        ItemKey yeastKey = this.stackToKey(yeast);
        if (!this.yeastToBiomeName.containsKey(yeastKey)) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Initializing yeast to biome name set for %s", (Object)yeast);
            this.yeastToBiomeName.put(yeastKey, new HashSet());
        }
        this.yeastToBiomeName.get(yeastKey).add(name);
        if (!this.biomeNameToYeast.containsKey(name)) {
            GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Initializing biome name to yeast set for %s", (Object)name);
            this.biomeNameToYeast.put(name, new HashSet());
        }
        this.biomeNameToYeast.get(name).add(new WeightedItemStack(weight, yeast));
    }

    public Set<WeightedItemStack> getYeastListForBiomeType(@Nonnull BiomeDictionary.Type type) {
        return this.biomeTypeToYeast.get(type);
    }

    public Set<WeightedItemStack> getYeastListForBiomeName(@Nonnull String type) {
        return this.biomeNameToYeast.get(type);
    }

    public Set<String> getBiomeNamesForYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return null;
        }
        return this.yeastToBiomeName.get(this.stackToKey(yeast));
    }

    public Set<BiomeDictionary.Type> getBiomeTypesForYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return null;
        }
        return this.yeastToBiomeType.get(this.stackToKey(yeast));
    }

    public boolean canYeastFormInBiome(@Nullable ItemStack yeast, @Nullable Biome biome) {
        if (yeast == null || biome == null) {
            return false;
        }
        Set<String> biomeNames = this.getBiomeNamesForYeast(yeast);
        if (biomeNames != null && biomeNames.contains(biome.field_76791_y)) {
            return true;
        }
        Set<BiomeDictionary.Type> yeastBiomeList = this.getBiomeTypesForYeast(yeast);
        if (yeastBiomeList != null) {
            for (BiomeDictionary.Type t : BiomeDictionary.getTypes((Biome)biome)) {
                if (!yeastBiomeList.contains(t)) continue;
                return true;
            }
        }
        return false;
    }
}

