/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.block.BlockFruitPresser;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.processing.pressing.IPressingRecipe;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FruitPress
extends DeviceProgressive {
    private float pomace;
    private DeviceFluidSlot fluidSlot;
    private DeviceInventorySlot inputSlot;
    private DeviceInventorySlot residueSlot;
    private IPressingRecipe currentResult;

    public FruitPress(TileEntityCellarDevice te, int fs, int is, int rs) {
        super(te);
        this.fluidSlot = new DeviceFluidSlot(te, fs);
        this.inputSlot = new DeviceInventorySlot((IInventory)te, is);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, rs);
    }

    public boolean isPressed() {
        return this.getWorld().func_180495_p(this.parent.func_174877_v().func_177984_a()).func_177229_b(BlockFruitPresser.TYPE_PRESSED) == BlockFruitPresser.PressState.PRESSED;
    }

    private boolean preparePressing() {
        this.currentResult = null;
        ItemStack primarySlotItem = this.inputSlot.get();
        if (primarySlotItem == null) {
            return false;
        }
        if (!this.isPressed()) {
            return false;
        }
        if (this.fluidSlot.isFull()) {
            return false;
        }
        IPressingRecipe result = CellarRegistry.instance().pressing().getPressingRecipe(primarySlotItem);
        if (result == null) {
            return false;
        }
        if (!this.inputSlot.hasEnough(result.getInput())) {
            return false;
        }
        this.currentResult = result;
        this.setTimeMax(this.currentResult.getTime());
        if (this.fluidSlot.isEmpty()) {
            return true;
        }
        FluidStack stack = this.currentResult.getFluidStack();
        return stack.isFluidEqual(this.fluidSlot.get());
    }

    public void producePomace() {
        if (this.currentResult == null) {
            return;
        }
        Residue residue = this.currentResult.getResidue();
        if (residue != null) {
            this.pomace += residue.pomaceRate;
            if (this.pomace >= 1.0f) {
                this.pomace -= 1.0f;
                ItemStack residueResult = ItemUtils.mergeStacks(this.residueSlot.get(), residue.residueItem);
                if (!ItemUtils.isEmpty(residueResult)) {
                    this.residueSlot.set(residueResult);
                }
            }
        }
    }

    public void pressItem() {
        if (this.currentResult == null) {
            return;
        }
        ItemStack pressingItem = this.inputSlot.get();
        this.producePomace();
        FluidStack fluidstack = this.currentResult.getFluidStack();
        this.fluidSlot.fill(fluidstack, true);
        this.inputSlot.consume(this.currentResult.getInput());
    }

    @Override
    public void update() {
        if (this.preparePressing()) {
            this.increaseTime();
            if (this.getTime() >= this.getTimeMax()) {
                this.resetTime();
                this.pressItem();
                this.markDirty();
            }
        } else if (this.resetTime()) {
            this.markDirty();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pomace = data.func_74760_g("pomace");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("pomace", this.pomace);
    }
}

