/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity;

import growthcraft.cellar.common.inventory.ContainerFermentBarrel;
import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.device.FermentBarrel;
import growthcraft.cellar.common.tileentity.fluids.CellarTank;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.inventory.GrowthcraftInternalInventory;
import growthcraft.core.shared.inventory.InventoryProcessor;
import growthcraft.core.shared.io.nbt.INBTItemSerializable;
import growthcraft.core.shared.tileentity.event.TileEventHandler;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityFermentBarrel
extends TileEntityCellarDevice
implements IInventory,
ITickable,
ITileProgressiveDevice,
INBTItemSerializable {
    private static final int[] accessableSlotIds = new int[]{0};
    private final FermentBarrel fermentBarrel = new FermentBarrel(this, 0, 1, 0);

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new CellarTank(GrowthcraftCellarConfig.fermentBarrelMaxCap, this)};
    }

    @Override
    public GrowthcraftInternalInventory createInventory() {
        return new GrowthcraftInternalInventory(this, 2);
    }

    @Override
    public String getDefaultInventoryName() {
        return "container.grc.fermentBarrel";
    }

    @Override
    public String getGuiID() {
        return "growthcraft_cellar:ferment_barrel";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFermentBarrel(playerInventory, this);
    }

    public int getTime() {
        return this.fermentBarrel.getTime();
    }

    public int getTimeMax() {
        return this.fermentBarrel.getTimeMax();
    }

    @Override
    public float getDeviceProgress() {
        return this.fermentBarrel.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.fermentBarrel.getProgressScaled(scale);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.fermentBarrel.update();
        }
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return accessableSlotIds;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack itemstack) {
        return index == 0;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return InventoryProcessor.instance().canInsertItem(this, stack, slot);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return InventoryProcessor.instance().canExtractItem(this, stack, slot);
    }

    @Override
    protected void readTanksFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Tank")) {
            this.getFluidTank(0).readFromNBT(nbt.func_74775_l("Tank"));
        } else {
            super.readTanksFromNBT(nbt);
        }
    }

    @Override
    public void readFromNBTForItem(NBTTagCompound nbt) {
        super.readFromNBTForItem(nbt);
        this.fermentBarrel.readFromNBT(nbt, "ferment_barrel");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_READ)
    public void readFromNBT_FermentBarrel(NBTTagCompound nbt) {
        this.fermentBarrel.readFromNBT(nbt, "ferment_barrel");
    }

    @Override
    public void writeToNBTForItem(NBTTagCompound nbt) {
        super.writeToNBTForItem(nbt);
        this.fermentBarrel.writeToNBT(nbt, "ferment_barrel");
    }

    @TileEventHandler(event=TileEventHandler.EventType.NBT_WRITE)
    public void writeToNBT_FermentBarrel(NBTTagCompound nbt) {
        this.fermentBarrel.writeToNBT(nbt, "ferment_barrel");
    }

    @Override
    public void receiveGUINetworkData(int id, int v) {
        super.receiveGUINetworkData(id, v);
        switch (FermentBarrelDataID.getByaOrdinal(id)) {
            case TIME: {
                this.fermentBarrel.setTime(v);
                break;
            }
            case TIME_MAX: {
                this.fermentBarrel.setTimeMax(v);
                break;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, IContainerListener iCrafting) {
        super.sendGUINetworkData(container, iCrafting);
        iCrafting.func_71112_a(container, FermentBarrelDataID.TIME.ordinal(), this.fermentBarrel.getTime());
        iCrafting.func_71112_a(container, FermentBarrelDataID.TIME_MAX.ordinal(), this.fermentBarrel.getTimeMax());
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_READ)
    public boolean readFromStream_FermentBarrel(ByteBuf stream) throws IOException {
        this.fermentBarrel.readFromStream(stream);
        return false;
    }

    @TileEventHandler(event=TileEventHandler.EventType.NETWORK_WRITE)
    public boolean writeToStream_FermentBarrel(ByteBuf stream) throws IOException {
        this.fermentBarrel.writeToStream(stream);
        return false;
    }

    @Override
    public boolean canFill(EnumFacing from, Fluid fluid) {
        FluidStack fluidStack = this.getFluidStack(0);
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return true;
        }
        return FluidTest.fluidMatches(fluidStack, fluid);
    }

    @Override
    protected int doFill(EnumFacing from, FluidStack resource, boolean shouldFill) {
        return this.fillFluidTank(0, resource, shouldFill);
    }

    @Override
    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return FluidTest.fluidMatches(this.getFluidStack(0), fluid);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, int maxDrain, boolean shouldDrain) {
        return this.drainFluidTank(0, maxDrain, shouldDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing from, FluidStack resource, boolean shouldDrain) {
        if (resource == null || !resource.isFluidEqual(this.getFluidStack(0))) {
            return null;
        }
        return this.doDrain(from, resource.amount, shouldDrain);
    }

    @Override
    protected void markFluidDirty() {
        super.markFluidDirty();
        this.fermentBarrel.markForRecipeRecheck();
    }

    @Override
    public void onInventoryChanged(IInventory inv, int index) {
        super.onInventoryChanged(inv, index);
        this.fermentBarrel.markForRecipeRecheck();
        if (index == 1) {
            this.markDirtyAndUpdate();
        }
    }

    public boolean hasTap() {
        return GrowthcraftCellarItems.barrelTap.equals(this.func_70301_a(1).func_77973_b());
    }

    public static enum FermentBarrelDataID {
        TIME,
        TIME_MAX,
        UNKNOWN;

        public static final FermentBarrelDataID[] VALID;

        public static FermentBarrelDataID getByaOrdinal(int ord) {
            if (ord >= 0 && ord <= VALID.length) {
                return VALID[ord];
            }
            return UNKNOWN;
        }

        static {
            VALID = new FermentBarrelDataID[]{TIME, TIME_MAX};
        }
    }
}

