/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.block.BlockFruitPress;
import growthcraft.cellar.common.block.BlockRotatableCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityFruitPresser;
import growthcraft.cellar.shared.init.GrowthcraftCellarBlocks;
import growthcraft.core.shared.block.IRotatableBlock;
import growthcraft.core.shared.block.IWrenchable;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFruitPresser
extends BlockCellarContainer
implements IWrenchable,
IRotatableBlock {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.9375, 0.8125);
    public static final PropertyEnum<Orient> TYPE_ORIENT = PropertyEnum.func_177709_a((String)"orient", Orient.class);
    public static final PropertyEnum<PressState> TYPE_PRESSED = PropertyEnum.func_177709_a((String)"pressed", PressState.class);

    public BlockFruitPresser(String unlocalizedName) {
        super(Material.field_76233_E);
        this.field_149758_A = true;
        this.setTileEntityType(TileEntityFruitPresser.class);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_cellar", unlocalizedName));
        this.setHarvestLevel("axe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockFruitPresser.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (below instanceof IRotatableBlock) {
            return ((IRotatableBlock)below).isRotatable(world, pos.func_177977_b(), side);
        }
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        if (this.isRotatable((IBlockAccess)world, pos, side)) {
            Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            return below.rotateBlock(world, pos.func_177977_b(), side);
        }
        return false;
    }

    @Override
    public boolean wrenchBlock(World world, BlockPos pos, EntityPlayer player, ItemStack wrench) {
        Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (below instanceof BlockFruitPress) {
            return ((BlockFruitPress)below).wrenchBlock(world, pos.func_177977_b(), player, wrench);
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        Block below = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (below instanceof BlockFruitPress) {
            return ((BlockFruitPress)below).tryWrenchItem(playerIn, worldIn, pos.func_177977_b());
        }
        return false;
    }

    private void updateOrientWithPress(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)BlockRotatableCellarContainer.TYPE_ROTATION);
        Orient orient = Orient.fromFacing(facing);
        world.func_180501_a(pos, state.func_177226_a(TYPE_ORIENT, (Comparable)((Object)orient)), 3);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.updateOrientWithPress(world, pos, state);
        if (!world.field_72995_K) {
            this.updatePressState(world, pos);
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updateOrientWithPress(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.updatePressState(worldIn, pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175655_b(pos, false);
        }
        if (!worldIn.field_72995_K) {
            this.updatePressState(worldIn, pos);
        }
    }

    private void updatePressState(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != GrowthcraftCellarBlocks.fruitPresser.getBlock()) {
            return;
        }
        boolean flag = world.func_175640_z(pos);
        PressState pressed = (PressState)((Object)state.func_177229_b(TYPE_PRESSED));
        if (flag && pressed == PressState.UNPRESSED) {
            world.func_180501_a(pos, state.func_177226_a(TYPE_PRESSED, (Comparable)((Object)PressState.PRESSED)), 3);
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f, false);
        } else if (!flag && pressed == PressState.PRESSED) {
            world.func_180501_a(pos, state.func_177226_a(TYPE_PRESSED, (Comparable)((Object)PressState.UNPRESSED)), 3);
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f, false);
        }
        this.markBlockForUpdate(world, pos);
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return GrowthcraftCellarBlocks.fruitPress.getBlock() == world.func_180495_p(pos.func_177977_b()).func_177230_c();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Orient orient = (Orient)((Object)state.func_177229_b(TYPE_ORIENT));
        if (orient == Orient.TOEAST) {
            return side == EnumFacing.EAST || side == EnumFacing.WEST;
        }
        if (orient == Orient.TOSOUTH) {
            return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
        }
        return this.isNormalCube(state, world, pos);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return GrowthcraftCellarBlocks.fruitPress.getItemAsStack(1, 0);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ORIENT, TYPE_PRESSED});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_ORIENT, (Comparable)((Object)Orient.values()[meta & 1])).func_177226_a(TYPE_PRESSED, (Comparable)((Object)PressState.values()[meta >> 1 & 1]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Orient)((Object)state.func_177229_b(TYPE_ORIENT))).ordinal() | ((PressState)((Object)state.func_177229_b(TYPE_PRESSED))).ordinal() << 1;
    }

    public static enum PressState implements IStringSerializable
    {
        UNPRESSED,
        PRESSED;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }

    public static enum Orient implements IStringSerializable
    {
        TOEAST,
        TOSOUTH;


        public static Orient fromFacing(EnumFacing facing) {
            if (facing == EnumFacing.EAST || facing == EnumFacing.WEST) {
                return TOEAST;
            }
            return TOSOUTH;
        }

        public EnumFacing toFacing() {
            return this == TOEAST ? EnumFacing.EAST : EnumFacing.SOUTH;
        }

        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

