/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.block;

import growthcraft.cellar.common.block.BlockCellarContainer;
import growthcraft.cellar.common.tileentity.TileEntityBrewKettle;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.init.GrowthcraftCellarItems;
import growthcraft.core.shared.item.ItemUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBrewKettle
extends BlockCellarContainer {
    private static final AxisAlignedBB AABB_CONTENTS = new AxisAlignedBB(0.125, 0.25, 0.125, 0.75, 0.625, 0.75);
    private static final PropertyBool TYPE_LID = PropertyBool.func_177716_a((String)"haslid");
    private static final AxisAlignedBB AABB_FULL_BLOCK = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    private static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    private static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private static final AxisAlignedBB AABB_LID = new AxisAlignedBB(0.125, 0.875, 0.125, 0.875, 1.0, 0.875);

    public BlockBrewKettle(String unlocalizedName) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setTileEntityType(TileEntityBrewKettle.class);
        this.func_149711_c(2.0f);
        this.func_149663_c(unlocalizedName);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)TYPE_LID, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(new ResourceLocation("growthcraft_cellar", unlocalizedName));
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntityBrewKettle te;
        if (GrowthcraftCellarConfig.brewKettleFillsWithRain && (te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)world, pos)) != null && !te.hasLid()) {
            te.fill(EnumFacing.UP, new FluidStack(FluidRegistry.WATER, GrowthcraftCellarConfig.brewKettleRainFillPerUnit), true);
        }
        super.func_176224_k(world, pos);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityBrewKettle te;
        if (!worldIn.field_72995_K && (te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)worldIn, pos)) != null && !te.hasLid()) {
            Vec3d epos;
            EntityItem item;
            if (GrowthcraftCellarConfig.dropItemsInBrewKettle && entityIn instanceof EntityItem && !GrowthcraftCellarItems.brewKettleLid.equals((item = (EntityItem)entityIn).func_92059_d().func_77973_b()) && !ItemUtils.isEmpty(te.tryMergeItemIntoMainSlot(item.func_92059_d()))) {
                worldIn.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
            }
            if (GrowthcraftCellarConfig.setFireToFallenLivingEntities && entityIn instanceof EntityLivingBase && AABB_CONTENTS.func_72318_a(epos = new Vec3d(entityIn.field_70165_t - (double)pos.func_177958_n(), entityIn.field_70163_u - (double)pos.func_177956_o(), entityIn.field_70161_v - (double)pos.func_177952_p()))) {
                boolean containsLava;
                boolean isFull = te.isFluidTankFull(0) || te.isFluidTankFull(1);
                boolean bl = containsLava = te.getFluid(0) == FluidRegistry.LAVA || te.getFluid(1) == FluidRegistry.LAVA;
                if (containsLava || te.getHeatMultiplier() >= 0.5f) {
                    entityIn.func_70015_d(1);
                } else if (isFull && entityIn.func_70027_ad()) {
                    entityIn.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                    entityIn.func_70066_B();
                }
            }
        }
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            TileEntityBrewKettle te = (TileEntityBrewKettle)this.getTileEntity(worldIn, pos);
            if (te != null && te.hasLid()) {
                return BlockFaceShape.SOLID;
            }
            return BlockFaceShape.BOWL;
        }
        return face == EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BASE);
        BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
        BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        if (((Boolean)state.func_177229_b((IProperty)TYPE_LID)).booleanValue()) {
            BlockBrewKettle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LID);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_FULL_BLOCK;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_LID});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityBrewKettle te = (TileEntityBrewKettle)this.getTileEntity(worldIn, pos);
        if (te != null && te.hasLid()) {
            return state.func_177226_a((IProperty)TYPE_LID, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityBrewKettle te = (TileEntityBrewKettle)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            return te.getFluidAmountScaled(15, 1);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
    }
}

