/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.client.gui;

import growthcraft.cellar.GrowthcraftCellar;
import growthcraft.cellar.client.gui.GuiCellar;
import growthcraft.cellar.common.inventory.ContainerFermentBarrel;
import growthcraft.cellar.common.lib.network.PacketClearTankButton;
import growthcraft.cellar.common.tileentity.TileEntityFermentBarrel;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.client.gui.widget.GuiButtonDiscard;
import growthcraft.core.shared.fluids.FluidTag;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFermentBarrel
extends GuiCellar<ContainerFermentBarrel, TileEntityFermentBarrel> {
    public static final ResourceLocation FERMENT_BARREL_TEXTURE = new ResourceLocation("growthcraft_cellar", "textures/guis/fermentbarrel_gui.png");
    private GuiButtonDiscard button;

    public GuiFermentBarrel(InventoryPlayer inv, TileEntityFermentBarrel fermentBarrel) {
        super(FERMENT_BARREL_TEXTURE, new ContainerFermentBarrel(inv, fermentBarrel), fermentBarrel);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.button = new GuiButtonDiscard(this.guiResource, 1, this.field_147003_i + 116, this.field_147009_r + 54);
        this.field_146292_n.add(this.button);
        this.button.field_146124_l = false;
        this.addTooltipIndex("fluidtank.primary", 63, 17, 50, 52);
        this.addTooltipIndex("progress_indicator", 42, 22, 3, 26);
        if (this.button != null) {
            this.addTooltipIndex("discard.fluidtank.primary", 116, 54, 16, 16);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.button != null) {
            this.button.field_146124_l = ((TileEntityFermentBarrel)this.tileEntity).isFluidTankFilled(0);
        }
    }

    protected void func_146284_a(GuiButton butn) {
        GrowthcraftCellar.packetPipeline.sendToServer(new PacketClearTankButton(((TileEntityFermentBarrel)this.tileEntity).func_174877_v()));
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        int i;
        super.func_146976_a(par1, par2, par3);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (((TileEntityFermentBarrel)this.tileEntity).getTime() > 0) {
            int k1;
            i = ((TileEntityFermentBarrel)this.tileEntity).getDeviceProgressScaled(29);
            if (i > 0) {
                this.func_73729_b(x + 39, y + 21 + 29 - i, 188, 29 - i, 9, i);
            }
            if ((i = (k1 = ((TileEntityFermentBarrel)this.tileEntity).getTime() / 2 % 60) * 29 / 60) > 0) {
                this.func_73729_b(x + 49, y + 20 + 29 - i, 176, 29 - i, 12, i);
            }
        }
        if ((i = ((TileEntityFermentBarrel)this.tileEntity).getFluidAmountScaled(52, 0)) > 0) {
            FluidStack fluid = ((TileEntityFermentBarrel)this.tileEntity).getFluidStack(0);
            this.drawTank(63, 17, x, y, 50, 52, i, ((TileEntityFermentBarrel)this.tileEntity).getFluidTank(0));
            this.bindGuiTexture();
            this.field_146296_j.field_77023_b = 100.0f;
            Collection<FluidTag> tags = CoreRegistry.instance().fluidDictionary().getFluidTags(fluid);
            if (tags != null) {
                if (tags.contains(BoozeTag.FERMENTED)) {
                    this.field_146296_j.func_180450_b(new ItemStack(Items.field_151075_bm), x + 114, y + 16);
                }
                if (tags.contains(BoozeTag.EXTENDED)) {
                    this.field_146296_j.func_180450_b(new ItemStack(Items.field_151137_ax), x + 114, y + 32);
                }
                if (tags.contains(BoozeTag.HYPER_EXTENDED)) {
                    this.field_146296_j.func_180450_b(new ItemStack(Items.field_151137_ax), x + 114, y + 32);
                }
                if (tags.contains(BoozeTag.POTENT)) {
                    this.field_146296_j.func_180450_b(new ItemStack(Items.field_151114_aO), x + 130, y + 32);
                }
            }
            this.field_146296_j.field_77023_b = 0.0f;
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (!((TileEntityFermentBarrel)this.tileEntity).isFluidTankEmpty(0)) {
            String s = String.valueOf(((TileEntityFermentBarrel)this.tileEntity).getFluidAmount(0));
            this.field_146289_q.func_175063_a(s, (float)(this.field_146999_f - 62 - this.field_146289_q.func_78256_a(s)), (float)(this.field_147000_g - 104), 0xFFFFFF);
        }
    }

    @Override
    public void addTooltips(String handle, List<String> tooltip) {
        switch (handle) {
            case "progress_indicator": {
                tooltip.add(I18n.func_135052_a((String)I18n.func_135052_a((String)(TextFormatting.WHITE + String.valueOf(((TileEntityFermentBarrel)this.tileEntity).getDeviceProgressScaled(100))), (Object[])new Object[0]), (Object[])new Object[0]) + "%");
                break;
            }
            case "fluidtank.primary": {
                if (!((TileEntityFermentBarrel)this.tileEntity).isFluidTankFilled(0)) break;
                this.addFermentTooltips(((TileEntityFermentBarrel)this.tileEntity).getFluidStack(0), tooltip);
                break;
            }
            case "discard.fluidtank.primary": {
                tooltip.add(I18n.func_135052_a((String)"gui.grc.discard", (Object[])new Object[0]));
                break;
            }
        }
    }
}

