/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar;

import growthcraft.cellar.client.gui.GuiHandler;
import growthcraft.cellar.common.CommonProxy;
import growthcraft.cellar.common.Init;
import growthcraft.cellar.common.compat.thaumcraft.CellarAspectRegistry;
import growthcraft.cellar.common.handlers.EventHandlerLivingUpdateEventCellar;
import growthcraft.cellar.common.lib.network.PacketPipeline;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.CellarBoozeBuilderFactory;
import growthcraft.cellar.shared.booze.modifier.GrowthcraftModifierFunctions;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.config.UserApis;
import growthcraft.core.shared.compat.Compat;
import growthcraft.core.shared.inventory.GrowthcraftGuiProvider;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="growthcraft_cellar", name="Growthcraft Cellar", version="4.0.4.500", dependencies="required-after:growthcraft", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftCellar {
    static final String CLIENT_PROXY_CLASS = "growthcraft.cellar.client.ClientProxy";
    static final String SERVER_PROXY_CLASS = "growthcraft.cellar.common.CommonProxy";
    @Mod.Instance(value="growthcraft_cellar")
    public static GrowthcraftCellar instance;
    @SidedProxy(serverSide="growthcraft.cellar.common.CommonProxy", clientSide="growthcraft.cellar.client.ClientProxy")
    public static CommonProxy proxy;
    public static GrowthcraftGuiProvider guiProvider;
    public static final PacketPipeline packetPipeline;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        GrowthcraftCellarConfig.preInit(event);
        Init.preInitEffects();
        GrowthcraftCellarApis.userApis = new UserApis();
        GrowthcraftCellarApis.userApis.getUserBrewingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/brewing.json");
        GrowthcraftCellarApis.userApis.getUserCultureRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/culturing.json");
        GrowthcraftCellarApis.userApis.getUserFermentingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/fermenting.json");
        GrowthcraftCellarApis.userApis.getUserHeatSources().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/heatsources.json");
        GrowthcraftCellarApis.userApis.getUserPressingRecipes().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/pressing.json");
        GrowthcraftCellarApis.userApis.getUserYeastEntries().setConfigFile(event.getModConfigurationDirectory(), "growthcraft/cellar/yeast.json");
        GrowthcraftCellarApis.boozeBuilderFactory = new CellarBoozeBuilderFactory(GrowthcraftCellarApis.userApis);
        GrowthcraftModifierFunctions.registerBoozeModifierFunctions();
        Init.preInitHeatSources();
        Init.registerHeatSources();
        Init.preInitBlocks();
        Init.preInitItems();
        proxy.preInit();
        proxy.registerTitleEntities();
        GrowthcraftCellarApis.userApis.preInit();
        GrowthcraftCellarApis.userApis.register();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        Init.initYeasts();
        Init.registerYeasts();
        packetPipeline.initialise();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)"growthcraft_cellar", (IGuiHandler)guiProvider);
        Init.registerRecipes();
        proxy.init();
        GrowthcraftCellarApis.userApis.init();
        if (Compat.isModAvailable_Thaumcraft()) {
            CellarAspectRegistry.register();
        }
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        GrowthcraftCellarApis.userApis.loadConfigs();
        packetPipeline.postInitialise();
        GrowthcraftCellarApis.userApis.postInit();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerLivingUpdateEventCellar());
        CellarRegistry.onPostInit();
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlockItems((IForgeRegistry<Item>)registry);
        Init.registerItems((IForgeRegistry<Item>)registry);
        proxy.postRegisterItems();
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerPotions((IForgeRegistry<Potion>)registry);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Init.registerItemRenders();
        Init.registerBlockRenders();
    }

    static {
        guiProvider = new GuiHandler();
        packetPipeline = new PacketPipeline();
        FluidRegistry.enableUniversalBucket();
    }
}

