/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.lib.config.user;

import growthcraft.bees.common.lib.config.BeesRegistry;
import growthcraft.bees.common.lib.config.ForcedFlowerBlockEntry;
import growthcraft.bees.common.lib.config.user.UserFlowerEntry;
import growthcraft.bees.common.lib.config.user.UserFlowersEntries;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.config.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.block.Block;

public class UserFlowersConfig
extends AbstractUserJSONConfig {
    private final UserFlowersEntries defaultEntries = new UserFlowersEntries();
    private UserFlowersEntries entries;

    public UserFlowerEntry addDefault(UserFlowerEntry entry) {
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserFlowerEntry addDefault(Block flower, int meta) {
        return this.addDefault(new UserFlowerEntry(flower, meta));
    }

    public UserFlowerEntry addDefault(Block flower) {
        return this.addDefault(flower, Short.MAX_VALUE);
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserFlowersEntries)this.gson.fromJson((Reader)buff, UserFlowersEntries.class);
    }

    private void addFlowerEntry(UserFlowerEntry entry) {
        if (entry == null) {
            GrowthcraftLogger.getLogger("growthcraft_bees").error("Invalid Entry");
            return;
        }
        if (entry.block == null || entry.block.isInvalid()) {
            GrowthcraftLogger.getLogger("growthcraft_bees").error("Invalid block for entry {%s}", (Object)entry);
            return;
        }
        switch (entry.entry_type) {
            case "generic": {
                BeesRegistry.instance().addFlower(entry.block.getBlock(), entry.block.meta);
                break;
            }
            case "forced": {
                BeesRegistry.instance().addFlower(new ForcedFlowerBlockEntry(entry.block.getBlock(), entry.block.meta));
                break;
            }
            default: {
                GrowthcraftLogger.getLogger("growthcraft_bees").error("Invalid entry_type '%s' for entry {%s}", (Object)entry.entry_type, (Object)entry);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                GrowthcraftLogger.getLogger("growthcraft_bees").debug("Adding %d user flower entries.", (Object)this.entries.data.size());
                for (UserFlowerEntry entry : this.entries.data) {
                    this.addFlowerEntry(entry);
                }
            } else {
                GrowthcraftLogger.getLogger("growthcraft_bees").error("Config contains invalid data.");
            }
        }
    }
}

