/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bamboo.common.worldgen;

import growthcraft.bamboo.shared.init.GrowthcraftBambooBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class WorldGenBambooTree
extends WorldGenAbstractTree {
    private int minBambooTreeHieght = 6;
    private int maxBambooTreeHieght = 12;
    private final boolean useExtraRandomHeight;

    public WorldGenBambooTree(boolean notify, boolean useExtraRandomHeightIn) {
        super(notify);
        this.useExtraRandomHeight = useExtraRandomHeightIn;
    }

    public boolean canGrow(World worldIn, BlockPos pos, int height) {
        for (int i = 1; i <= height; ++i) {
            Block block = worldIn.func_180495_p(pos.func_177981_b(i)).func_177230_c();
            if (block instanceof BlockAir) continue;
            return false;
        }
        return true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        int height;
        if (!worldIn.field_72995_K && this.canGrow(worldIn, pos, height = rand.nextInt(this.maxBambooTreeHieght - this.minBambooTreeHieght) + this.minBambooTreeHieght)) {
            worldIn.func_175656_a(pos, GrowthcraftBambooBlocks.bambooStalk.getDefaultState());
            for (int i = 1; i <= height; ++i) {
                worldIn.func_175656_a(pos.func_177981_b(i), GrowthcraftBambooBlocks.bambooStalk.getDefaultState());
                if (i != height) continue;
                this.spawnLeaves(worldIn, pos.func_177981_b(i + 1));
                this.spawnLeaves(worldIn, pos.func_177981_b(i).func_177978_c());
                this.spawnLeaves(worldIn, pos.func_177981_b(i).func_177974_f());
                this.spawnLeaves(worldIn, pos.func_177981_b(i).func_177968_d());
                this.spawnLeaves(worldIn, pos.func_177981_b(i).func_177976_e());
                this.spawnLeaves(worldIn, pos.func_177981_b(i - 3).func_177978_c());
                this.spawnLeaves(worldIn, pos.func_177981_b(i - 3).func_177974_f());
                this.spawnLeaves(worldIn, pos.func_177981_b(i - 3).func_177968_d());
                this.spawnLeaves(worldIn, pos.func_177981_b(i - 3).func_177976_e());
            }
            return true;
        }
        return false;
    }

    private void spawnLeaves(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() instanceof BlockAir) {
            worldIn.func_175656_a(pos, GrowthcraftBambooBlocks.bambooLeaves.getDefaultState());
        }
    }
}

