/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common.block;

import growthcraft.apples.shared.init.GrowthcraftApplesBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAppleLeaves
extends BlockLeaves
implements IGrowable {
    public static final int LEAVES_COLOR = 5825053;
    private static final int APPLE_CHECK_AREA = 3;
    private static final int MAX_APPLES_IN_AREA = 2;

    public BlockAppleLeaves(String unlocalizedName) {
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_apples", unlocalizedName));
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(blockState, blockAccess, pos, side);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.canSustainApple(worldIn, pos, state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockAir) {
            worldIn.func_175656_a(pos.func_177977_b(), GrowthcraftApplesBlocks.blockApple.getDefaultState());
        }
    }

    private boolean canSustainApple(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return false;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return false;
        }
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block instanceof BlockAir;
    }

    private boolean canSpawnApple(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canSustainApple(worldIn, pos, state)) {
            return false;
        }
        int iX = pos.func_177958_n();
        int iY = pos.func_177956_o();
        int iZ = pos.func_177952_p();
        BlockPos.MutableBlockPos mutpos = new BlockPos.MutableBlockPos();
        int countApples = 0;
        for (int jX = -3; jX <= 3; ++jX) {
            for (int jY = -3; jY <= 3; ++jY) {
                for (int jZ = -3; jZ <= 3; ++jZ) {
                    mutpos.func_181079_c(iX + jX, iY + jY, iZ + jZ);
                    IBlockState iblockstate = worldIn.func_180495_p((BlockPos)mutpos);
                    if (iblockstate.func_177230_c() != GrowthcraftApplesBlocks.blockApple.getBlock() || ++countApples < 2) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && worldIn.func_175671_l(pos.func_177984_a()) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(7) == 0 ? 1 : 0) != 0) && this.canSpawnApple(worldIn, pos, state)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    protected int func_176232_d(IBlockState state) {
        return 20;
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
        if (worldIn.field_73012_v.nextInt(chance) == 0) {
            BlockAppleLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Items.field_151034_e));
        }
    }

    public int func_149679_a(int fortune, Random random) {
        return MathHelper.func_76125_a((int)(this.func_149745_a(random) + random.nextInt(fortune + 1)), (int)0, (int)2);
    }

    public int func_149745_a(Random random) {
        return random.nextInt(5) == 0 ? 1 : 0;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return GrowthcraftApplesBlocks.blockAppleSapling.getItem();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, 0));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }
}

