/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.apples.common;

import growthcraft.apples.common.block.BlockApple;
import growthcraft.apples.common.block.BlockAppleDoor;
import growthcraft.apples.common.block.BlockAppleFence;
import growthcraft.apples.common.block.BlockAppleFenceGate;
import growthcraft.apples.common.block.BlockAppleLeaves;
import growthcraft.apples.common.block.BlockAppleLog;
import growthcraft.apples.common.block.BlockApplePlanks;
import growthcraft.apples.common.block.BlockAppleSapling;
import growthcraft.apples.common.block.BlockAppleSlabDouble;
import growthcraft.apples.common.block.BlockAppleSlabHalf;
import growthcraft.apples.common.block.BlockAppleStairs;
import growthcraft.apples.common.item.ItemAppleDoor;
import growthcraft.apples.common.item.ItemAppleLeaves;
import growthcraft.apples.shared.config.GrowthcraftApplesConfig;
import growthcraft.apples.shared.init.GrowthcraftApplesBlocks;
import growthcraft.apples.shared.init.GrowthcraftApplesFluids;
import growthcraft.apples.shared.init.GrowthcraftApplesItems;
import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeRegistryHelper;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.definition.BlockBoozeDefinition;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.config.GrowthcraftCoreConfig;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.BlockTypeDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.effect.AbstractEffectList;
import growthcraft.core.shared.effect.EffectAddPotionEffect;
import growthcraft.core.shared.effect.EffectRandomList;
import growthcraft.core.shared.effect.EffectWeightedRandomList;
import growthcraft.core.shared.effect.IEffect;
import growthcraft.core.shared.effect.SimplePotionEffectFactory;
import growthcraft.core.shared.item.OreItemStacks;
import growthcraft.core.shared.utils.ColorUtils;
import growthcraft.core.shared.utils.TickUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftApplesBlocks.blockApple = new BlockDefinition((Block)new BlockApple("apple_crop"));
        GrowthcraftApplesBlocks.blockAppleDoor = new BlockDefinition((Block)new BlockAppleDoor("apple_door"));
        GrowthcraftApplesBlocks.blockAppleFence = new BlockDefinition((Block)new BlockAppleFence("apple_fence"));
        GrowthcraftApplesBlocks.blockAppleFenceGate = new BlockDefinition((Block)new BlockAppleFenceGate("apple_fence_gate"));
        GrowthcraftApplesBlocks.blockAppleLeaves = new BlockTypeDefinition<BlockAppleLeaves>(new BlockAppleLeaves("apple_leaves"));
        GrowthcraftApplesBlocks.blockAppleLog = new BlockDefinition((Block)new BlockAppleLog("apple_log"));
        GrowthcraftApplesBlocks.blockApplePlanks = new BlockDefinition(new BlockApplePlanks("apple_planks"));
        GrowthcraftApplesBlocks.blockAppleSapling = new BlockDefinition((Block)new BlockAppleSapling("apple_sapling"));
        GrowthcraftApplesBlocks.blockAppleSlabHalf = new BlockTypeDefinition<BlockAppleSlabHalf>(new BlockAppleSlabHalf("apple_slab_half"));
        GrowthcraftApplesBlocks.blockAppleSlabDouble = new BlockTypeDefinition<BlockAppleSlabDouble>(new BlockAppleSlabDouble("apple_slab_double"));
        GrowthcraftApplesBlocks.blockAppleStairs = new BlockDefinition((Block)new BlockAppleStairs("apple_stairs", GrowthcraftApplesBlocks.blockApplePlanks.getDefaultState()));
    }

    public static void registerBlockOres() {
        OreDictionary.registerOre((String)"plankWood", (Item)GrowthcraftApplesBlocks.blockApplePlanks.getItem());
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftApplesBlocks.blockApple.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleDoor.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleFence.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleFence.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleFenceGate.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleFenceGate.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleLeaves.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleLeaves.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleLog.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleLog.registerBlock(registry);
        GrowthcraftApplesBlocks.blockApplePlanks.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockApplePlanks.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleSapling.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleSapling.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleSlabHalf.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleSlabHalf.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleSlabDouble.registerBlock(registry);
        GrowthcraftApplesBlocks.blockAppleStairs.getBlock().func_149647_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesBlocks.blockAppleStairs.registerBlock(registry);
    }

    public static void registerBlockItems(IForgeRegistry<Item> registry) {
        GrowthcraftApplesBlocks.blockAppleFence.registerBlockItem(registry);
        GrowthcraftApplesBlocks.blockAppleFenceGate.registerBlockItem(registry);
        GrowthcraftApplesBlocks.blockAppleLeaves.registerBlockItem(registry, (ItemBlock)new ItemAppleLeaves(GrowthcraftApplesBlocks.blockAppleLeaves.getBlock()));
        GrowthcraftApplesBlocks.blockAppleLog.registerBlockItem(registry);
        GrowthcraftApplesBlocks.blockApplePlanks.registerBlockItem(registry);
        GrowthcraftApplesBlocks.blockAppleSapling.registerBlockItem(registry);
        GrowthcraftApplesBlocks.blockAppleSlabHalf.registerBlockItem(registry, (ItemBlock)new ItemSlab((Block)GrowthcraftApplesBlocks.blockAppleSlabHalf.getBlock(), GrowthcraftApplesBlocks.blockAppleSlabHalf.getBlock(), GrowthcraftApplesBlocks.blockAppleSlabDouble.getBlock()));
        GrowthcraftApplesBlocks.blockAppleStairs.registerBlockItem(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenders() {
        GrowthcraftApplesBlocks.blockApple.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleDoor.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleFence.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleFenceGate.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleLeaves.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleLog.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleSapling.registerItemRender();
        GrowthcraftApplesBlocks.blockApplePlanks.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleStairs.registerItemRender();
        GrowthcraftApplesBlocks.blockAppleSlabHalf.registerItemRender();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockColorHandlers() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, worldIn, pos, tintindex) -> {
            float[] color = ColorUtils.getFloat4ARGB(5825053);
            if (worldIn != null && pos != null) {
                int i;
                float[] baseColor = ColorUtils.getFloat4ARGB(ColorizerFoliage.func_77468_c());
                float[] curColor = ColorUtils.getFloat4ARGB(BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos));
                float[] colorRatio = new float[3];
                for (i = 1; i < 3; ++i) {
                    colorRatio[i - 1] = curColor[i] / baseColor[i];
                }
                for (i = 1; i < 3; ++i) {
                    int n = i;
                    color[n] = color[n] * colorRatio[i - 1];
                }
            }
            return ColorUtils.getIntARGB(color);
        }, new Block[]{GrowthcraftApplesBlocks.blockAppleLeaves.getBlock()});
    }

    @SideOnly(value=Side.CLIENT)
    public static void setCustomBlockStateMappers() {
        ModelLoader.setCustomStateMapper((Block)GrowthcraftApplesBlocks.blockAppleLeaves.getBlock(), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockAppleLeaves.field_176237_a, BlockAppleLeaves.field_176236_b}).func_178441_a());
        ModelLoader.setCustomStateMapper(GrowthcraftApplesBlocks.blockAppleFenceGate.getBlock(), (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockFenceGate.field_176465_b}).func_178441_a());
    }

    public static void preInitItems() {
        GrowthcraftApplesItems.itemAppleDoor = new ItemDefinition((Item)new ItemAppleDoor("apple_door_item", (Block)GrowthcraftApplesBlocks.blockAppleDoor.getBlock()));
        GrowthcraftApplesItems.appleCider = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
    }

    public static void registerItemOres() {
        OreDictionary.registerOre((String)"foodApple", (Item)Items.field_151034_e);
        OreDictionary.registerOre((String)"foodFruit", (Item)Items.field_151034_e);
        OreDictionary.registerOre((String)"foodApplejuice", (ItemStack)GrowthcraftApplesItems.appleCider.asStack(1, 0));
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftApplesItems.itemAppleDoor.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesItems.itemAppleDoor.registerItem(registry);
        GrowthcraftApplesItems.appleCider.registerItem(registry, new ResourceLocation("growthcraft_apples", "applecider"));
        GrowthcraftApplesItems.appleCider.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftApplesItems.appleCider.getItem().setBoozes(GrowthcraftApplesFluids.appleCiderBooze);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        GrowthcraftApplesItems.itemAppleDoor.registerRender();
        GrowthcraftApplesItems.appleCider.registerRenders(GrowthcraftApplesItems.AppleCiderTypes.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColorHandlers() {
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftApplesItems.appleCider.getItem());
        final BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(iblockstate, (IBlockAccess)null, (BlockPos)null, tintIndex);
            }
        }, new Block[]{GrowthcraftApplesBlocks.blockAppleLeaves.getBlock()});
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemVariants() {
        GrowthcraftApplesItems.appleCider.registerModelBakeryVariants(GrowthcraftApplesItems.AppleCiderTypes.class);
    }

    public static void preInitFluids() {
        GrowthcraftApplesFluids.appleCiderBooze = new BoozeDefinition[GrowthcraftApplesItems.AppleCiderTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftApplesFluids.appleCiderBooze, GrowthcraftApplesItems.AppleCiderTypes.class, "");
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_JUICE.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_ETHEREAL.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.silkenNectarColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_INTOXICATED.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
        ((Booze)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POISONED.ordinal()].getFluid()).setColor(GrowthcraftApplesConfig.appleCiderColor).setDensity(1010);
    }

    public static void registerFluidBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftApplesBlocks.appleCiderFluidBlocks = new BlockBoozeDefinition[GrowthcraftApplesFluids.appleCiderBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftApplesFluids.appleCiderBooze, GrowthcraftApplesBlocks.appleCiderFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftApplesFluids.appleCiderBooze, 1, -0.3f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_JUICE.ordinal()], 1, 0.3f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftApplesFluids.appleCiderBooze, GrowthcraftApplesBlocks.appleCiderFluidBlocks, "growthcraft_apples", "applecider", GrowthcraftApplesItems.AppleCiderTypes.class);
    }

    public static void initBoozes() {
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftApplesFluids.appleCiderBooze, GrowthcraftApplesItems.appleCider, "growthcraft_apples", "applecider", GrowthcraftApplesItems.AppleCiderTypes.class);
        Init.registerFermentations();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRenders() {
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftApplesFluids.appleCiderBooze, GrowthcraftApplesBlocks.appleCiderFluidBlocks);
    }

    private static void registerFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = new FluidStack[GrowthcraftApplesFluids.appleCiderBooze.length];
        for (int i = 0; i < GrowthcraftApplesFluids.appleCiderBooze.length; ++i) {
            fs[i] = GrowthcraftApplesFluids.appleCiderBooze[i].asFluidStack();
        }
        FluidStack[] spoilInputFs = new FluidStack[GrowthcraftApplesFluids.appleCiderBooze.length];
        for (int i = 0; i < GrowthcraftApplesFluids.appleCiderBooze.length; ++i) {
            spoilInputFs[i] = GrowthcraftApplesFluids.appleCiderBooze[i].asFluidStack(40);
        }
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_JUICE.ordinal()].getFluid()).tags(BoozeTag.YOUNG).pressesFrom(new OreItemStacks("foodApple"), TickUtils.seconds(2), 40, Residue.newDefault(0.3f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_JUICE.ordinal()], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_JUICE.ordinal()], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.045f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76444_x, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.08f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76444_x, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.045f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76444_x, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_ETHEREAL.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED, BoozeTag.MAGICAL).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.045f), TickUtils.seconds(45)).addEffect((IEffect)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)((AbstractEffectList)new EffectRandomList().add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76424_c, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76422_e, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76420_g, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_180152_w, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76430_j, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76428_l, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76429_m, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76426_n, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76427_o, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76441_p, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76439_r, TickUtils.minutes(10), 0)))).add(new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76444_x, TickUtils.minutes(10), 0))));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_INTOXICATED.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.112500004f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76444_x, TickUtils.seconds(90), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_82731_v, TickUtils.seconds(90), 2))));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftApplesFluids.appleCiderBooze[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POISONED.ordinal()].getFluid()).tags(BoozeTag.CIDER, BoozeTag.FERMENTED, BoozeTag.POISONED).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_FERMENTED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POTENT.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_EXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_ETHEREAL.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_ETHEREAL.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_ETHEREAL.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_INTOXICATED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_INTOXICATED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_INTOXICATED.ordinal()], TickUtils.minutes(1), null).fermentsFromFallback(fs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POISONED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftApplesItems.AppleCiderTypes.APPLE_CIDER_POISONED.ordinal()], TickUtils.minutes(1), null).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.045f), TickUtils.seconds(45)).createPotionEntry(MobEffects.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthcraftCoreConfig.hidePoisonedBooze);
    }

    public static void registerRecipes() {
        Init.registerCraftingRecipes();
    }

    private static void registerCraftingRecipes() {
    }
}

