/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.collect.OrderedEnumMap;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.statements.ActionPipeDirection;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PipeBehaviourDirectional
extends PipeBehaviour {
    public static final OrderedEnumMap<EnumFacing> ROTATION_ORDER = VanillaRotationHandlers.ROTATE_FACING;
    protected EnumPipePart currentDir = EnumPipePart.CENTER;

    public PipeBehaviourDirectional(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourDirectional(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.setCurrentDir((EnumFacing)NBTUtilBC.readEnum((NBTBase)nbt.func_74781_a("currentDir"), EnumFacing.class));
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("currentDir", NBTUtilBC.writeEnum((Enum)this.getCurrentDir()));
        return nbt;
    }

    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        PacketBufferBC bufBc = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        bufBc.writeEnumValue((Enum)this.currentDir);
    }

    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        this.currentDir = (EnumPipePart)PacketBufferBC.asPacketBufferBc((ByteBuf)buffer).func_179257_a(EnumPipePart.class);
    }

    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
            EntityUtil.activateWrench((EntityPlayer)player, (RayTraceResult)trace);
            if (part == EnumPipePart.CENTER) {
                return this.advanceFacing();
            }
            if (part.face != this.getCurrentDir() && this.canFaceDirection(part.face)) {
                this.setCurrentDir(part.face);
            }
            return true;
        }
        return false;
    }

    public void onTick() {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        if (!this.canFaceDirection(this.getCurrentDir()) && !this.advanceFacing()) {
            this.setCurrentDir(null);
        }
    }

    protected abstract boolean canFaceDirection(EnumFacing var1);

    public boolean advanceFacing() {
        EnumFacing current = this.currentDir.face;
        for (int i = 0; i < 6; ++i) {
            if (!this.canFaceDirection(current = (EnumFacing)ROTATION_ORDER.next((Enum)current))) continue;
            this.setCurrentDir(current);
            return true;
        }
        return false;
    }

    @Nullable
    protected EnumFacing getCurrentDir() {
        return this.currentDir.face;
    }

    protected void setCurrentDir(EnumFacing setTo) {
        if (this.currentDir.face == setTo) {
            return;
        }
        this.currentDir = EnumPipePart.fromFacing((EnumFacing)setTo);
        if (!this.pipe.getHolder().getPipeWorld().field_72995_K) {
            this.pipe.getHolder().scheduleNetworkUpdate(new IPipeHolder.PipeMessageReceiver[]{IPipeHolder.PipeMessageReceiver.BEHAVIOUR});
        }
    }

    @PipeEventHandler
    public void addActions(PipeEventStatement.AddActionInternal event) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!this.canFaceDirection(face)) continue;
            event.actions.add(BCTransportStatements.ACTION_PIPE_DIRECTION[face.ordinal()]);
        }
    }

    @PipeEventHandler
    public void onActionActivate(PipeEventActionActivate event) {
        if (event.action instanceof ActionPipeDirection) {
            ActionPipeDirection action = (ActionPipeDirection)event.action;
            if (this.canFaceDirection(action.direction)) {
                this.setCurrentDir(action.direction);
            }
        }
    }
}

