/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.waila;

import extracells.tileentity.TileEntityCertusTank;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileCertusTankWailaDataProvider
implements IWailaDataProvider {
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos blockPos) {
        if (tile instanceof TileEntityCertusTank) {
            TileEntityCertusTank tileTank = (TileEntityCertusTank)tile;
            IFluidTankProperties properties = tileTank.getTankInfo(true)[0];
            FluidStack content = properties.getContents();
            if (content == null || content.getFluid() == null) {
                tag.func_74778_a("fluidName", "");
            } else {
                tag.func_74778_a("fluidName", content.getFluid().getName());
                tag.func_74768_a("currentFluid", content.amount);
            }
            tag.func_74768_a("maxFluid", properties.getCapacity());
        }
        return tag;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> list, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String fluidName;
        NBTTagCompound tag = accessor.getNBTData();
        if (tag == null) {
            return list;
        }
        if (tag.func_74764_b("fluidName")) {
            fluidName = tag.func_74779_i("fluidName");
            if (fluidName.isEmpty()) {
                list.add(I18n.func_74838_a((String)"extracells.tooltip.fluid") + ": " + I18n.func_74838_a((String)"extracells.tooltip.empty1"));
                list.add(I18n.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB / " + tag.func_74762_e("maxFluid") + "mB");
                return list;
            }
        } else {
            return list;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        list.add(I18n.func_74838_a((String)"extracells.tooltip.fluid") + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1000)));
        if (tag.func_74764_b("maxFluid") && tag.func_74764_b("currentFluid")) {
            list.add(I18n.func_74838_a((String)"extracells.tooltip.amount") + ": " + tag.func_74762_e("currentFluid") + "mB / " + tag.func_74762_e("maxFluid") + "mB");
        }
        return list;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return accessor.getStack();
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }
}

