/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerManager;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.helpers.NBTHelper;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.packet.PacketStevesCarts;

public abstract class TileEntityManager
extends TileEntityBase
implements IInventory {
    private TransferManager standardTransferHandler;
    private NonNullList<ItemStack> cargoItemStacks;
    public int layoutType;
    public int moveTime = 0;
    public boolean[] toCart = new boolean[]{true, true, true, true};
    public boolean[] doReturn = new boolean[]{false, false, false, false};
    public int[] amount = new int[]{0, 0, 0, 0};
    public int[] color = new int[]{1, 2, 3, 4};

    public TileEntityManager() {
        this.cargoItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.standardTransferHandler = new TransferManager();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.cargoItemStacks.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.cargoItemStacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        this.cargoItemStacks.set(i, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        this.cargoItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound2.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.cargoItemStacks.size()) continue;
            this.cargoItemStacks.set((int)byte0, (Object)new ItemStack(nbttagcompound2));
        }
        this.moveTime = nbttagcompound.func_74771_c("movetime");
        this.setLowestSetting(nbttagcompound.func_74771_c("lowestNumber"));
        this.layoutType = nbttagcompound.func_74771_c("layout");
        byte temp = nbttagcompound.func_74771_c("tocart");
        byte temp2 = nbttagcompound.func_74771_c("doReturn");
        for (int j = 0; j < 4; ++j) {
            this.amount[j] = nbttagcompound.func_74771_c("amount" + j);
            this.color[j] = nbttagcompound.func_74771_c("color" + j);
            if (this.color[j] == 0) {
                this.color[j] = j + 1;
            }
            this.toCart[j] = (temp & 1 << j) != 0;
            this.doReturn[j] = (temp2 & 1 << j) != 0;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74774_a("movetime", (byte)this.moveTime);
        nbttagcompound.func_74774_a("lowestNumber", (byte)this.getLowestSetting());
        nbttagcompound.func_74774_a("layout", (byte)this.layoutType);
        byte temp = 0;
        byte temp2 = 0;
        for (int i = 0; i < 4; ++i) {
            nbttagcompound.func_74774_a("amount" + i, (byte)this.amount[i]);
            nbttagcompound.func_74774_a("color" + i, (byte)this.color[i]);
            if (this.toCart[i]) {
                temp = (byte)(temp | (byte)(1 << i));
            }
            if (!this.doReturn[i]) continue;
            temp2 = (byte)(temp2 | (byte)(1 << i));
        }
        nbttagcompound.func_74774_a("tocart", temp);
        nbttagcompound.func_74774_a("doReturn", temp2);
        NBTTagList nbttaglist = new NBTTagList();
        for (int j = 0; j < this.cargoItemStacks.size(); ++j) {
            if (((ItemStack)this.cargoItemStacks.get(j)).func_190926_b()) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            nbttagcompound2.func_74774_a("Slot", (byte)j);
            ((ItemStack)this.cargoItemStacks.get(j)).func_77955_b(nbttagcompound2);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        return nbttagcompound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public EntityMinecartModular getCart() {
        return this.standardTransferHandler.getCart();
    }

    public void setCart(EntityMinecartModular cart) {
        this.standardTransferHandler.setCart(cart);
    }

    public int getSetting() {
        return this.standardTransferHandler.getSetting();
    }

    public void setSetting(int val) {
        this.standardTransferHandler.setSetting(val);
    }

    public int getSide() {
        return this.standardTransferHandler.getSide();
    }

    public void setSide(int val) {
        this.standardTransferHandler.setSide(val);
    }

    public int getLastSetting() {
        return this.standardTransferHandler.getLastSetting();
    }

    public void setLastSetting(int val) {
        this.standardTransferHandler.setLastSetting(val);
    }

    public int getLowestSetting() {
        return this.standardTransferHandler.getLowestSetting();
    }

    public void setLowestSetting(int val) {
        this.standardTransferHandler.setLowestSetting(val);
    }

    public int getWorkload() {
        return this.standardTransferHandler.getWorkload();
    }

    public void setWorkload(int val) {
        this.standardTransferHandler.setWorkload(val);
    }

    @Override
    public void updateEntity() {
        if (this.field_145850_b.field_72995_K) {
            this.updateLayout();
            return;
        }
        if (this.getCart() == null || this.getCart().field_70128_L || this.getSide() < 0 || this.getSide() > 3 || !this.getCart().isDisabled()) {
            this.standardTransferHandler.reset();
            return;
        }
        ++this.moveTime;
        if (this.moveTime >= 24 || this.getSetting() == -1 && this.color[0] - 1 != this.getSide()) {
            this.moveTime = 0;
            if (!this.exchangeItems(this.standardTransferHandler)) {
                this.getCart().releaseCart();
                if (this.doReturn[this.getSide()]) {
                    this.getCart().turnback();
                }
                this.standardTransferHandler.reset();
            }
        }
    }

    public boolean exchangeItems(TransferManager transfer) {
        transfer.setSetting(transfer.getLowestSetting());
        while (transfer.getSetting() < 4) {
            if (this.color[transfer.getSetting()] - 1 == transfer.getSide()) {
                transfer.setLowestSetting(transfer.getSetting());
                if (transfer.getLastSetting() != transfer.getSetting()) {
                    transfer.setWorkload(0);
                    transfer.setLastSetting(transfer.getSetting());
                    return true;
                }
                if (!(this.toCart[transfer.getSetting()] ? transfer.getToCartEnabled() : transfer.getFromCartEnabled()) || !this.isTargetValid(transfer)) {
                    transfer.setLowestSetting(transfer.getSetting() + 1);
                    return true;
                }
                if (this.doTransfer(transfer)) {
                    return true;
                }
            }
            transfer.setSetting(transfer.getSetting() + 1);
        }
        return false;
    }

    public void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketStevesCarts.sendPacket(id, data);
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID2 = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference2 = k == 0 ? 1 : -1;
            if (id == 2) {
                int n;
                int[] amount = this.amount;
                int n2 = n = railID2;
                amount[n2] = amount[n2] + difference2;
                if (this.amount[railID2] >= this.getAmountCount()) {
                    this.amount[railID2] = 0;
                } else if (this.amount[railID2] < 0) {
                    this.amount[railID2] = this.getAmountCount() - 1;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                int n2;
                if (this.color[railID2] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID2 || this.color[railID2] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID2] - 1] = false;
                    }
                }
                int[] color = this.color;
                int n = n2 = railID2;
                color[n] = color[n] + difference2;
                if (this.color[railID2] > 5) {
                    this.color[railID2] = 1;
                } else if (this.color[railID2] < 1) {
                    this.color[railID2] = 5;
                }
                if (this.color[railID2] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID2, difference2);
            }
        }
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
        this.checkGuiData((ContainerManager)con, crafting, true);
    }

    @Override
    public void checkGuiData(Container con, IContainerListener crafting) {
        this.checkGuiData((ContainerManager)con, crafting, false);
    }

    public void checkGuiData(ContainerManager con, IContainerListener crafting, boolean isNew) {
        int i;
        short header = (short)(this.moveTime & 0x1F);
        header = (short)(header | (short)((this.layoutType & 3) << 5));
        for (i = 0; i < 4; ++i) {
            header = (short)(header | (short)((this.toCart[i] ? 1 : 0) << 7 + i));
        }
        for (i = 0; i < 4; ++i) {
            header = (short)(header | (short)((this.doReturn[i] ? 1 : 0) << 11 + i));
        }
        if (isNew || con.lastHeader != header) {
            this.updateGuiData(con, crafting, 0, header);
            con.lastHeader = header;
        }
        short colorShort = 0;
        for (int j = 0; j < 4; ++j) {
            colorShort = (short)(colorShort | (short)((this.color[j] & 7) << j * 3));
        }
        colorShort = (short)(colorShort | (short)((this.getLastSetting() & 7) << 12));
        if (isNew || con.lastColor != colorShort) {
            this.updateGuiData(con, crafting, 1, colorShort);
            con.lastColor = colorShort;
        }
        short amountShort = 0;
        for (int k = 0; k < 4; ++k) {
            amountShort = (short)(amountShort | (short)((this.amount[k] & 0xF) << k * 4));
        }
        if (isNew || con.lastAmount != amountShort) {
            this.updateGuiData(con, crafting, 3, amountShort);
            con.lastAmount = amountShort;
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        block5: {
            block6: {
                block4: {
                    int i;
                    if (id != 0) break block4;
                    this.moveTime = data & 0x1F;
                    this.layoutType = (data & 0x60) >> 5;
                    this.updateLayout();
                    for (i = 0; i < 4; ++i) {
                        this.toCart[i] = (data & 1 << 7 + i) != 0;
                    }
                    for (i = 0; i < 4; ++i) {
                        this.doReturn[i] = (data & 1 << 11 + i) != 0;
                    }
                    break block5;
                }
                if (id != 1) break block6;
                for (int i = 0; i < 4; ++i) {
                    this.color[i] = (data & 7 << i * 3) >> i * 3;
                }
                this.setLastSetting((data & 0x7000) >> 12);
                break block5;
            }
            if (id != 3) break block5;
            for (int i = 0; i < 4; ++i) {
                this.amount[i] = (data & 15 << i * 4) >> i * 4;
            }
        }
    }

    public int moveProgressScaled(int i) {
        return this.moveTime * i / 24;
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int par1) {
        if (!((ItemStack)this.cargoItemStacks.get(par1)).func_190926_b()) {
            ItemStack var2 = (ItemStack)this.cargoItemStacks.get(par1);
            this.cargoItemStacks.set(par1, (Object)ItemStack.field_190927_a);
            return var2;
        }
        return ItemStack.field_190927_a;
    }

    protected void updateLayout() {
    }

    protected void receiveClickData(int packetid, int id, int dif) {
    }

    protected abstract boolean isTargetValid(TransferManager var1);

    protected abstract boolean doTransfer(TransferManager var1);

    public abstract int getAmountCount();

    protected void reset() {
        this.moveTime = 0;
        this.setWorkload(0);
    }

    protected int getAmountId(int id) {
        return this.amount[id];
    }

    public int func_70302_i_() {
        return this.cargoItemStacks.size();
    }

    @Nullable
    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.cargoItemStacks, (int)index);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.cargoItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return "container.cargomanager";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)new InvWrapper((IInventory)this);
        }
        return (T)super.getCapability(capability, facing);
    }
}

