/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyArray;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyTable;
import WayofTime.bloodmagic.api.impl.recipe.RecipeBloodAltar;
import WayofTime.bloodmagic.api.impl.recipe.RecipeTartaricForge;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="bloodmagic")
public class PluginBloodMagic
extends PEIPlugin {
    public PluginBloodMagic(String modid, Configuration config) {
        super(modid, config);
    }

    @Override
    public void setup() {
        this.addMapper(new AlchemyArrayMapper());
        this.addMapper(new AlchemyTableMapper());
        this.addMapper(new BloodAltarMapper());
        this.addMapper(new TartaricForgeMapper());
    }

    private class TartaricForgeMapper
    extends PEIMapper {
        public TartaricForgeMapper() {
            super("Tartaric Forge");
        }

        @Override
        public void setup() {
            for (RecipeTartaricForge recipe : BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForgeRecipes()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput().toArray());
            }
        }
    }

    private class BloodAltarMapper
    extends PEIMapper {
        public BloodAltarMapper() {
            super("Blood Altar");
        }

        @Override
        public void setup() {
            for (RecipeBloodAltar recipe : BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAltarRecipes()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput());
            }
        }
    }

    private class AlchemyTableMapper
    extends PEIMapper {
        public AlchemyTableMapper() {
            super("Alchemy Table");
        }

        @Override
        public void setup() {
            for (RecipeAlchemyTable recipe : BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyRecipes()) {
                this.addRecipe(recipe.getOutput(), recipe.getInput().toArray());
            }
        }
    }

    private class AlchemyArrayMapper
    extends PEIMapper {
        public AlchemyArrayMapper() {
            super("Alchemy Array");
        }

        @Override
        public void setup() {
            for (RecipeAlchemyArray recipe : BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyArrayRecipes()) {
                this.addRecipe(recipe.getOutput(), recipe.getCatalyst(), recipe.getInput());
            }
        }
    }
}

