/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.plugins;

import com.google.common.collect.ImmutableMap;
import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.PEIPlugin;
import com.tagnumelite.projecteintegration.api.RegPEIPlugin;
import com.tagnumelite.projecteintegration.api.mappers.PEIMapper;
import java.util.Map;
import morph.avaritia.init.ModItems;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.compressor.ICompressorRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@RegPEIPlugin(modid="avaritia")
public class PluginAvaritia
extends PEIPlugin {
    private final float compressor_cost_multiplier;

    public PluginAvaritia(String modid, Configuration config) {
        super(modid, config);
        this.compressor_cost_multiplier = config.getFloat("compressor_cost_multiplier", this.category, 1.0f, 1.0E-5f, 1.0f, "Mupltier to the EMC calulation");
    }

    @Override
    public void setup() {
        this.addEMC(ModItems.neutron_pile, 128);
        this.addMapper(new ExtremeMapper());
        this.addMapper(new CompressorMapper());
    }

    private class CompressorMapper
    extends PEIMapper {
        public CompressorMapper() {
            super("Compressor");
        }

        @Override
        public void setup() {
            for (ICompressorRecipe recipe : AvaritiaRecipeManager.COMPRESSOR_RECIPES.values()) {
                ItemStack output = recipe.getResult();
                if (output.func_190926_b()) continue;
                this.addConversion(output, (Map<Object, Integer>)ImmutableMap.of((Object)PEIApi.getList(recipe.getIngredients()), (Object)Math.max(Math.round((float)recipe.getCost() * PluginAvaritia.this.compressor_cost_multiplier), 1)));
            }
        }
    }

    private class ExtremeMapper
    extends PEIMapper {
        public ExtremeMapper() {
            super("Extreme Crafting Table");
        }

        @Override
        public void setup() {
            for (IExtremeRecipe recipe : AvaritiaRecipeManager.EXTREME_RECIPES.values()) {
                this.addRecipe(recipe.getRecipeOutput(), recipe.getIngredients().toArray());
            }
        }
    }
}

