/*
 * Decompiled with CFR 0.152.
 */
package com.tagnumelite.projecteintegration.api.mappers;

import com.tagnumelite.projecteintegration.api.PEIApi;
import com.tagnumelite.projecteintegration.api.utils.Utils;
import java.util.Map;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.proxy.IConversionProxy;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ClassUtils;

public abstract class PEIMapper {
    public final String name;
    public final String desc;
    public final boolean disabled_by_default;
    protected final IConversionProxy conversion_proxy;

    public PEIMapper(String name, String description) {
        this(name, description, false);
    }

    public PEIMapper(String name, boolean disabledByDefault) {
        this(name, "Enable mapper for " + name + '?', disabledByDefault);
    }

    public PEIMapper(String name) {
        this(name, "Enable mapper for " + name + '?');
    }

    protected PEIMapper(String name, String description, boolean disableByDefault) {
        this.name = name;
        this.desc = description;
        this.disabled_by_default = disableByDefault;
        this.conversion_proxy = ProjectEAPI.getConversionProxy();
    }

    public abstract void setup();

    protected void addRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output == null || output.func_190926_b()) {
            return;
        }
        IngredientMap ingredients = new IngredientMap();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            if (ingredient == Ingredient.field_193370_a) continue;
            ingredients.addIngredient(PEIApi.getIngredient(ingredient), 1);
        }
        this.addConversion(output, (Map<Object, Integer>)ingredients.getMap());
    }

    protected void addRecipe(ItemStack output, Object ... inputs) {
        if (output == null || output.func_190926_b()) {
            return;
        }
        this.addRecipe(output.func_190916_E(), (Object)output.func_77946_l(), inputs);
    }

    protected void addRecipe(FluidStack output, Object ... inputs) {
        if (output == null || output.amount <= 0) {
            return;
        }
        this.addRecipe(output.amount, (Object)output.copy(), inputs);
    }

    protected void addRecipe(int output_amount, Object output, Object ... inputs) {
        if (output_amount <= 0 || output == null || inputs == null || inputs.length <= 0) {
            return;
        }
        this.addConversion(output_amount, output, Utils.createInputs(inputs).getMap());
    }

    protected void addConversion(ItemStack item, Map<Object, Integer> input) {
        if (item == null || item.func_190926_b()) {
            PEIApi.LOG.warn("Output Item is either null or Empty: {} from {}", (Object)item, input);
            return;
        }
        this.addConversion(item.func_190916_E(), item.func_77946_l(), input);
    }

    protected void addConversion(FluidStack fluid, Map<Object, Integer> input) {
        if (fluid == null || fluid.amount == 0) {
            PEIApi.LOG.warn("Output Fluid is either null or Empty: {} from {}", (Object)fluid, input);
            return;
        }
        this.addConversion(fluid.amount, fluid.copy(), input);
    }

    protected void addConversion(int output_amount, Object output, Map<Object, Integer> input) {
        if (output_amount <= 0 || output == null || input == null || input.isEmpty()) {
            Object output_l = output;
            if (output instanceof FluidStack) {
                output_l = ((FluidStack)output).getFluid().getName();
            }
            PEIApi.LOG.warn("Invalid Conversion: [{} ({})]*{} from {}", output_l, (Object)ClassUtils.getPackageCanonicalName(output.getClass()), (Object)output_amount, input);
            return;
        }
        try {
            this.conversion_proxy.addConversion(output_amount, output, input);
            ++PEIApi.mapped_conversions;
        }
        catch (Exception e) {
            PEIApi.LOG.error("Failed to add conversion: {}*{} from {}; {}", output, (Object)output_amount, input, (Object)e);
        }
    }
}

