/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IExtraFunction;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MercurialEye
extends ItemMode
implements IExtraFunction {
    private static final int CREATION_MODE = 0;
    private static final int EXTENSION_MODE = 1;
    private static final int EXTENSION_MODE_CLASSIC = 2;
    private static final int TRANSMUTATION_MODE = 3;
    private static final int TRANSMUTATION_MODE_CLASSIC = 4;
    private static final int PILLAR_MODE = 5;

    public MercurialEye() {
        super("mercurial_eye", 4, new String[]{"pe.pe_mercurial_eye.mode1", "pe.pe_mercurial_eye.mode2", "pe.pe_mercurial_eye.mode3", "pe.pe_mercurial_eye.mode4", "pe.pe_mercurial_eye.mode5", "pe.pe_mercurial_eye.mode6"});
        this.setNoRepair();
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound prevCapNBT) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            private final IItemHandler inv = new ItemStackHandler(2);

            public NBTTagCompound serializeNBT() {
                NBTTagCompound ret = new NBTTagCompound();
                NBTBase nbtBase = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
                if (nbtBase != null) {
                    ret.func_74782_a("Items", nbtBase);
                }
                return ret;
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, (NBTBase)nbt.func_150295_c("Items", 10));
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
                }
                return null;
            }
        };
    }

    @Override
    public boolean doExtraFunction(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, EnumHand hand) {
        player.openGui((Object)PECore.instance, 12, player.func_130014_f_(), hand == EnumHand.MAIN_HAND ? 0 : 1, -1, -1);
        return true;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return world.field_72995_K ? EnumActionResult.SUCCESS : this.formBlocks(stack, player, pos, facing);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getMode(stack) == 0) {
            if (world.field_72995_K) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            Vec3d eyeVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d lookVec = player.func_70040_Z();
            Vec3d targVec = eyeVec.func_72441_c(lookVec.field_72450_a * 2.0, lookVec.field_72448_b * 2.0, lookVec.field_72449_c * 2.0);
            return ActionResult.newResult((EnumActionResult)this.formBlocks(stack, player, new BlockPos(targVec), null), (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private EnumActionResult formBlocks(ItemStack eye, EntityPlayer player, BlockPos startingPos, @Nullable EnumFacing facing) {
        long newBlockEmc;
        IBlockState newState;
        IItemHandler inventory = (IItemHandler)eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory == null) {
            return EnumActionResult.FAIL;
        }
        ItemStack klein = inventory.getStackInSlot(0);
        if (klein.func_190926_b() || !(klein.func_77973_b() instanceof IItemEmc)) {
            return EnumActionResult.FAIL;
        }
        World world = player.func_130014_f_();
        IBlockState startingState = world.func_180495_p(startingPos);
        long startingBlockEmc = EMCHelper.getEmcValue(ItemHelper.stateToStack(startingState, 1));
        ItemStack target = inventory.getStackInSlot(1);
        byte mode = this.getMode(eye);
        if (!target.func_190926_b()) {
            newState = ItemHelper.stackToState(target);
            newBlockEmc = EMCHelper.getEmcValue(target);
        } else if (startingBlockEmc != 0L && (mode == 1 || mode == 2)) {
            newState = startingState;
            newBlockEmc = startingBlockEmc;
        } else {
            return EnumActionResult.FAIL;
        }
        if (newState == null || newState.func_177230_c().isAir(newState, null, null)) {
            return EnumActionResult.FAIL;
        }
        NonNullList drops = NonNullList.func_191196_a();
        int charge = this.getCharge(eye);
        int hitTargets = 0;
        if (mode == 0) {
            Block block = startingState.func_177230_c();
            if (facing != null && (!block.func_176200_f((IBlockAccess)world, startingPos) || player.func_70093_af() && !block.isAir(startingState, (IBlockAccess)world, startingPos))) {
                BlockPos offsetPos = startingPos.func_177972_a(facing);
                IBlockState offsetState = world.func_180495_p(offsetPos);
                if (!offsetState.func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) {
                    return EnumActionResult.FAIL;
                }
                long offsetBlockEmc = EMCHelper.getEmcValue(ItemHelper.stateToStack(offsetState, 1));
                if (this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                    ++hitTargets;
                }
            } else if (this.doBlockPlace(player, startingState, startingPos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) {
                ++hitTargets;
            }
        } else if (mode == 5) {
            hitTargets += this.fillGaps(eye, player, world, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, 1, 3 * charge + 2), (NonNullList<ItemStack>)drops);
        } else if (mode == 2) {
            hitTargets += this.fillGaps(eye, player, world, startingState, newState, newBlockEmc, this.getCorners(startingPos, facing, charge, 0), (NonNullList<ItemStack>)drops);
        } else if (mode == 4) {
            Pair<BlockPos, BlockPos> corners = this.getCorners(startingPos, facing, charge, 0);
            for (BlockPos pos : WorldHelper.getPositionsFromBox(new AxisAlignedBB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
                IBlockState placedState = world.func_180495_p(pos);
                if (placedState != startingState || !this.doBlockPlace(player, placedState, pos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops)) continue;
                ++hitTargets;
            }
        } else {
            if (startingState.func_177230_c().isAir(startingState, (IBlockAccess)world, startingPos) || facing == null) {
                return EnumActionResult.FAIL;
            }
            LinkedList<BlockPos> possibleBlocks = new LinkedList<BlockPos>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            possibleBlocks.add(startingPos);
            visited.add(startingPos);
            int side = 2 * charge + 1;
            int size = side * side;
            int totalTries = size * 4;
            for (int attemptedTargets = 0; attemptedTargets < totalTries && !possibleBlocks.isEmpty(); ++attemptedTargets) {
                BlockPos offsetPos;
                IBlockState offsetState;
                BlockPos pos = (BlockPos)possibleBlocks.poll();
                IBlockState checkState = world.func_180495_p(pos);
                if (startingState != checkState || (offsetState = world.func_180495_p(offsetPos = pos.func_177972_a(facing))).isSideSolid((IBlockAccess)world, offsetPos, facing)) continue;
                boolean hit = false;
                if (mode == 1) {
                    AxisAlignedBB cbBox = startingState.func_185890_d((IBlockAccess)world, offsetPos);
                    if (cbBox == null || world.func_72855_b(cbBox)) {
                        long offsetBlockEmc = EMCHelper.getEmcValue(ItemHelper.stateToStack(offsetState, 1));
                        hit = this.doBlockPlace(player, offsetState, offsetPos, newState, eye, offsetBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                    }
                } else if (mode == 3) {
                    hit = this.doBlockPlace(player, checkState, pos, newState, eye, startingBlockEmc, newBlockEmc, (NonNullList<ItemStack>)drops);
                }
                if (!hit) continue;
                if (++hitTargets < size) {
                    for (EnumFacing e : EnumFacing.field_82609_l) {
                        BlockPos offsetOpposite;
                        if (facing.func_176740_k() == e.func_176740_k()) continue;
                        BlockPos offset = pos.func_177972_a(e);
                        if (visited.add(offset)) {
                            possibleBlocks.offer(offset);
                        }
                        if (!visited.add(offsetOpposite = pos.func_177972_a(e.func_176734_d()))) continue;
                        possibleBlocks.offer(offsetOpposite);
                    }
                    continue;
                }
                break;
            }
        }
        if (hitTargets > 0) {
            if (PESounds.POWER != null) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.POWER, SoundCategory.PLAYERS, 0.8f, 2.0f / ((float)charge / (float)this.getNumCharges(eye) + 2.0f));
            }
            if (!drops.isEmpty()) {
                WorldHelper.createLootDrop((List<ItemStack>)drops, player.func_130014_f_(), startingPos);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean doBlockPlace(EntityPlayer player, IBlockState oldState, BlockPos placePos, IBlockState newState, ItemStack eye, long oldEMC, long newEMC, NonNullList<ItemStack> drops) {
        IItemHandler capability = (IItemHandler)eye.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (capability == null) {
            return false;
        }
        ItemStack klein = capability.getStackInSlot(0);
        if (klein.func_190926_b() || oldState == newState || ItemPE.getEmc(klein) < newEMC - oldEMC || player.func_130014_f_().func_175625_s(placePos) != null) {
            return false;
        }
        if (oldEMC == 0L && oldState.func_177230_c().field_149782_v == -1.0f) {
            return false;
        }
        if (PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, placePos, newState)) {
            IItemEmc itemEMC = (IItemEmc)klein.func_77973_b();
            if (oldEMC == 0L) {
                oldState.func_177230_c().getDrops(drops, (IBlockAccess)player.func_130014_f_(), placePos, oldState, 0);
                itemEMC.extractEmc(klein, newEMC);
            } else if (oldEMC > newEMC) {
                itemEMC.addEmc(klein, oldEMC - newEMC);
            } else if (oldEMC < newEMC) {
                itemEMC.extractEmc(klein, newEMC - oldEMC);
            }
            return true;
        }
        return false;
    }

    private int fillGaps(ItemStack eye, EntityPlayer player, World world, IBlockState startingState, IBlockState newState, long newBlockEmc, Pair<BlockPos, BlockPos> corners, NonNullList<ItemStack> drops) {
        int hitTargets = 0;
        for (BlockPos pos : WorldHelper.getPositionsFromBox(new AxisAlignedBB((BlockPos)corners.getLeft(), (BlockPos)corners.getRight()))) {
            long placeBlockEmc;
            IBlockState placeState;
            AxisAlignedBB bb = startingState.func_185890_d((IBlockAccess)world, pos);
            if (bb != null && !world.func_72855_b(bb) || !(placeState = world.func_180495_p(pos)).func_177230_c().func_176200_f((IBlockAccess)world, pos) || !this.doBlockPlace(player, placeState, pos, newState, eye, placeBlockEmc = EMCHelper.getEmcValue(ItemHelper.stateToStack(placeState, 1)), newBlockEmc, drops)) continue;
            ++hitTargets;
        }
        return hitTargets;
    }

    private Pair<BlockPos, BlockPos> getCorners(BlockPos startingPos, EnumFacing facing, int strength, int depth) {
        if (facing == null) {
            return new ImmutablePair((Object)startingPos, (Object)startingPos);
        }
        BlockPos start = startingPos;
        BlockPos end = startingPos;
        switch (facing) {
            case UP: {
                start = start.func_177982_a(-strength, -depth, -strength);
                end = end.func_177982_a(strength, 0, strength);
                break;
            }
            case DOWN: {
                start = start.func_177982_a(-strength, 0, -strength);
                end = end.func_177982_a(strength, depth, strength);
                break;
            }
            case SOUTH: {
                start = start.func_177982_a(-strength, -strength, -depth);
                end = end.func_177982_a(strength, strength, 0);
                break;
            }
            case NORTH: {
                start = start.func_177982_a(-strength, -strength, 0);
                end = end.func_177982_a(strength, strength, depth);
                break;
            }
            case EAST: {
                start = start.func_177982_a(-depth, -strength, -strength);
                end = end.func_177982_a(0, strength, strength);
                break;
            }
            case WEST: {
                start = start.func_177982_a(0, -strength, -strength);
                end = end.func_177982_a(depth, strength, strength);
            }
        }
        return new ImmutablePair((Object)start, (Object)end);
    }
}

