/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.DefaultKeyringConfig;

final class ResourceBasedKeyringConfig
extends DefaultKeyringConfig {
    private final ClassLoader classLoader;
    private final String publicKeyringPath;
    private final String secretKeyringPath;

    public ResourceBasedKeyringConfig(@Nonnull KeyringConfigCallback callback, @Nonnull ClassLoader classLoader, @Nonnull String publicKeyringPath, @Nonnull String secretKeyringPath) {
        super(callback);
        this.classLoader = classLoader;
        this.publicKeyringPath = publicKeyringPath;
        this.secretKeyringPath = secretKeyringPath;
    }

    @Override
    protected InputStream getPublicKeyRingStream() throws IOException {
        return this.classLoader.getResourceAsStream(this.publicKeyringPath);
    }

    @Override
    protected InputStream getSecretKeyRingStream() throws FileNotFoundException {
        return this.classLoader.getResourceAsStream(this.secretKeyringPath);
    }
}

