/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings;

import java.io.File;
import java.io.IOException;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.FileBasedKeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.InMemoryKeyring;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.ResourceBasedKeyringConfig;
import org.bouncycastle.openpgp.PGPException;

public final class KeyringConfigs {
    private KeyringConfigs() {
    }

    public static KeyringConfig withKeyRingsFromFiles(File publicKeyring, File secretKeyring, KeyringConfigCallback callback) {
        if (publicKeyring == null) {
            throw new IllegalArgumentException("keyring must not be null");
        }
        if (secretKeyring == null) {
            throw new IllegalArgumentException("secretKeyring must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        return new FileBasedKeyringConfig(callback, publicKeyring, secretKeyring);
    }

    public static KeyringConfig withKeyRingsFromResources(ClassLoader classLoader, String publicKeyringPath, String secretKeyringPath, KeyringConfigCallback callback) {
        if (publicKeyringPath == null) {
            throw new IllegalArgumentException("publicKeyringPath must not be null");
        }
        if (secretKeyringPath == null) {
            throw new IllegalArgumentException("secretKeyringPath must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        return new ResourceBasedKeyringConfig(callback, classLoader, publicKeyringPath, secretKeyringPath);
    }

    public static InMemoryKeyring forGpgExportedKeys(KeyringConfigCallback callback) throws IOException, PGPException {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        return new InMemoryKeyring(callback);
    }
}

