/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks;

import java.util.Map;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.KeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.StaticPasswordFromMapKeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.StaticPasswordKeyringConfigCallback;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.callbacks.UnprotectedKeysKeyringConfigCallback;

public final class KeyringConfigCallbacks {
    private KeyringConfigCallbacks() {
    }

    public static KeyringConfigCallback withPassword(char[] passphrase) {
        return new StaticPasswordKeyringConfigCallback(passphrase);
    }

    public static KeyringConfigCallback withPassword(String passphrase) {
        if (passphrase == null) {
            throw new NullPointerException("passphrase must not be null");
        }
        return KeyringConfigCallbacks.withPassword(passphrase.toCharArray());
    }

    public static KeyringConfigCallback withUnprotectedKeys() {
        return new UnprotectedKeysKeyringConfigCallback();
    }

    public static KeyringConfigCallback withPasswordsFromMap(Map<Long, char[]> copySourceKeyIdToPassphrase) {
        if (copySourceKeyIdToPassphrase == null) {
            throw new NullPointerException("copySourceKeyIdToPassphrase must not be null");
        }
        return new StaticPasswordFromMapKeyringConfigCallback(copySourceKeyIdToPassphrase);
    }
}

