/*
 * Decompiled with CFR 0.152.
 */
package name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.decrypting.SignatureValidatingInputStream;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.PGPUtilities;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.keys.keyrings.KeyringConfig;
import name.neuhalfen.projects.crypto.bouncycastle.openpgp.validation.SignatureValidationStrategy;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecryptionStreamFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecryptionStreamFactory.class);
    @Nonnull
    private final PGPContentVerifierBuilderProvider pgpContentVerifierBuilderProvider = new BcPGPContentVerifierBuilderProvider();
    @Nonnull
    private final KeyringConfig config;
    @Nonnull
    private final SignatureValidationStrategy signatureValidationStrategy;

    public static DecryptionStreamFactory create(KeyringConfig config, SignatureValidationStrategy signatureValidationStrategy) {
        if (config == null) {
            throw new IllegalArgumentException("keyring config must not be null");
        }
        if (signatureValidationStrategy == null) {
            throw new IllegalArgumentException("signatureValidationStrategy config must not be null");
        }
        return new DecryptionStreamFactory(config, signatureValidationStrategy);
    }

    private DecryptionStreamFactory(KeyringConfig config, SignatureValidationStrategy signatureValidationStrategy) {
        this.signatureValidationStrategy = signatureValidationStrategy;
        this.config = config;
    }

    public InputStream wrapWithDecryptAndVerify(InputStream in) throws IOException, NoSuchProviderException {
        LOGGER.trace("Trying to decrypt and verify PGP Encryption.");
        if (in == null) {
            throw new IllegalArgumentException("in config must not be null");
        }
        try {
            PGPObjectFactory factory = new PGPObjectFactory(PGPUtil.getDecoderStream(in), this.config.getKeyFingerPrintCalculator());
            return this.nextDecryptedStream(factory, new SignatureValidatingInputStream.DecryptionState());
        }
        catch (PGPException e) {
            throw new IOException("Failure decrypting", e);
        }
    }

    private InputStream nextDecryptedStream(PGPObjectFactory factory, SignatureValidatingInputStream.DecryptionState state) throws PGPException, IOException, NoSuchProviderException {
        Object pgpObj;
        while ((pgpObj = factory.nextObject()) != null) {
            if (pgpObj instanceof PGPEncryptedDataList) {
                LOGGER.trace("Found instance of PGPEncryptedDataList");
                PGPEncryptedDataList enc = (PGPEncryptedDataList)pgpObj;
                Iterator it = enc.getEncryptedDataObjects();
                if (!it.hasNext()) {
                    throw new PGPException("Decryption failed - No encrypted data found!");
                }
                PGPPrivateKey sKey = null;
                PGPPublicKeyEncryptedData pbe = null;
                while (sKey == null && it.hasNext()) {
                    pbe = (PGPPublicKeyEncryptedData)it.next();
                    sKey = PGPUtilities.findSecretKey(this.config.getSecretKeyRings(), pbe.getKeyID(), this.config.decryptionSecretKeyPassphraseForSecretKeyId(pbe.getKeyID()));
                }
                if (sKey == null) {
                    throw new PGPException("Decryption failed - No secret key was found in the key ring matching the public key used to encrypt the file, aborting");
                }
                InputStream plainText = pbe.getDataStream(new BcPublicKeyDataDecryptorFactory(sKey));
                PGPObjectFactory nextFactory = new PGPObjectFactory(plainText, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                return this.nextDecryptedStream(nextFactory, state);
            }
            if (pgpObj instanceof PGPCompressedData) {
                LOGGER.trace("Found instance of PGPCompressedData");
                PGPObjectFactory nextFactory = new PGPObjectFactory(((PGPCompressedData)pgpObj).getDataStream(), this.config.getKeyFingerPrintCalculator());
                return this.nextDecryptedStream(nextFactory, state);
            }
            if (pgpObj instanceof PGPOnePassSignatureList) {
                LOGGER.trace("Found instance of PGPOnePassSignatureList");
                if (!this.signatureValidationStrategy.isRequireSignatureCheck()) {
                    LOGGER.info("Signature check disabled - ignoring contained signature");
                    continue;
                }
                state.factory = factory;
                PGPOnePassSignatureList onePassSignatures = (PGPOnePassSignatureList)pgpObj;
                for (PGPOnePassSignature signature : onePassSignatures) {
                    PGPPublicKey pubKey = this.config.getPublicKeyRings().getPublicKey(signature.getKeyID());
                    if (pubKey != null) {
                        LOGGER.trace("Found signature and the public key '{}' was found in the keyring.", (Object)Long.toHexString(signature.getKeyID()));
                        signature.init(this.pgpContentVerifierBuilderProvider, pubKey);
                        state.addSignature(signature);
                        continue;
                    }
                    LOGGER.trace("Found signature but public key '{}' was not found in the keyring.", (Object)Long.toHexString(signature.getKeyID()));
                }
                if (state.numSignatures() != 0) continue;
                throw new PGPException("Signature checking is required but none of the public keys used to sign the data was found in the keyring'!");
            }
            if (pgpObj instanceof PGPLiteralData) {
                LOGGER.trace("Found instance of PGPLiteralData");
                if (this.signatureValidationStrategy.isRequireSignatureCheck()) {
                    if (state.numSignatures() == 0) {
                        throw new PGPException("Signature checking is required but message was not signed!");
                    }
                    return new SignatureValidatingInputStream(((PGPLiteralData)pgpObj).getInputStream(), state, this.signatureValidationStrategy);
                }
                return ((PGPLiteralData)pgpObj).getInputStream();
            }
            LOGGER.trace("Skipping pgp Object of Type {}", (Object)pgpObj.getClass().getSimpleName());
        }
        throw new PGPException("No data found");
    }
}

