/*
 * Decompiled with CFR 0.152.
 */
package com.michaelwflaherty.cleverbotapi;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class CleverBotQuery {
    public static final String URL_STRING = "http://www.cleverbot.com/getreply?key=";
    private String key;
    private String conversationID;
    private String phrase;
    private String response;
    private int random;

    public String getPhrase() {
        return this.phrase;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public String getResponse() {
        return this.response;
    }

    private void setResponse(String response) {
        this.response = response;
    }

    public String getAPIKey() {
        return this.key;
    }

    public void setConversationID(String conversationID) {
        this.conversationID = conversationID;
    }

    private void setRandomNumber(int number) {
        this.random = number;
    }

    public int getRandomNumber() {
        return this.random;
    }

    public String getConversationID() {
        return this.conversationID;
    }

    public void sendRequest() throws IOException {
        URL url = new URL(CleverBotQuery.formatRequest(URL_STRING, this.getAPIKey(), this.getPhrase(), this.getConversationID()));
        URLConnection urlConnection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        String inputLine = in.readLine();
        JsonObject jsonObject = new JsonParser().parse(inputLine).getAsJsonObject();
        this.setConversationID(jsonObject.get("cs").getAsString());
        this.setResponse(jsonObject.get("output").getAsString());
        this.setRandomNumber(Integer.parseInt(jsonObject.get("random_number").getAsString()));
        in.close();
    }

    public CleverBotQuery(String key, String phrase) {
        this.key = key;
        this.setConversationID("");
        this.setPhrase(phrase);
    }

    private static String formatRequest(String url, String key, String phrase, String conversationID) {
        String formattedPhrase = phrase.replace(' ', '+');
        if (conversationID.equals("")) {
            return url + key + "&input=" + formattedPhrase + "&wrapper=Headline22JavaAPI";
        }
        return url + key + "&input=" + formattedPhrase + "&wrapper=Headline22JavaAPI&cs=" + conversationID;
    }
}

