/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils.rfid;

import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.data.world.WorldDataRfidUniqueId;
import com.austinv11.peripheralsplusplus.init.ModItems;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class RfidTag {
    private static final String RFID_TAG = ModItems.RFID_CHIP.getRegistryName().toString();
    public static final int SECTOR_SIZE = 4;
    public static final int SECTORS = 16;
    public static final int BLOCK_LENGTH = 16;
    public static final int ID_SIZE = 7;
    public static final long MAX_ID = 0xFFFFFFFFFFFFFFL;
    public static final byte[] DEFAULT_KEY = new byte[]{-1, -1, -1, -1, -1, -1};
    public static final byte[] DEFAULT_ACCESS_BYTES = new byte[]{-1, 7, -128, 0};
    public static final int MANUFACTURER_BLOCK = 0;
    public static final int ACCESS_BITS_POSITION = DEFAULT_KEY.length;
    public static final int KEY_A_POSITION = 0;
    public static final int KEY_B_POSITION = 10;
    private static final String LORE_STRING = Colors.RESET + "Contains RFID Chip";
    private byte[][] blocks = new byte[64][16];

    private RfidTag() {
        for (int blockIndex = 0; blockIndex < 64; ++blockIndex) {
            if ((blockIndex + 1) % 4 != 0 || blockIndex == 0) continue;
            System.arraycopy(DEFAULT_KEY, 0, this.blocks[blockIndex], 0, DEFAULT_KEY.length);
            System.arraycopy(DEFAULT_KEY, 0, this.blocks[blockIndex], 10, DEFAULT_KEY.length);
            System.arraycopy(DEFAULT_ACCESS_BYTES, 0, this.blocks[blockIndex], ACCESS_BITS_POSITION, DEFAULT_ACCESS_BYTES.length);
        }
    }

    public RfidTag(ItemStack itemStack) {
        this();
        NBTTagCompound rfidTag = this.getTag(itemStack);
        if (rfidTag != null) {
            this.readFromNbt(rfidTag);
        }
    }

    @Nullable
    private NBTTagCompound getTag(ItemStack itemStack) {
        if (!RfidTag.hasTag(itemStack)) {
            return null;
        }
        return (NBTTagCompound)itemStack.func_77978_p().func_74781_a(RFID_TAG);
    }

    public static boolean hasTag(ItemStack itemStack) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(RFID_TAG);
    }

    public static void addTag(ItemStack item) {
        RfidTag.addTag(item, new RfidTag());
    }

    public static void addTag(ItemStack item, RfidTag rfidTag) {
        if (item.func_190926_b() || RfidTag.hasTag(item)) {
            return;
        }
        NBTTagCompound itemTag = item.func_77978_p();
        if (itemTag == null) {
            itemTag = new NBTTagCompound();
        }
        if (rfidTag.getIdLong() <= 0L) {
            rfidTag.setId();
        }
        NBTTagCompound rfidTagNbt = new NBTTagCompound();
        itemTag.func_74782_a(RFID_TAG, (NBTBase)rfidTag.writeToNbt(rfidTagNbt));
        item.func_77982_d(itemTag);
        if (!item.func_77969_a(new ItemStack(ModItems.RFID_CHIP))) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(LORE_STRING);
            NBTHelper.addInfo((ItemStack)item, text);
        }
    }

    public long getIdLong() {
        byte[] idPadded = new byte[8];
        byte[] id = this.getId();
        System.arraycopy(id, 0, idPadded, 1, 7);
        return Longs.fromByteArray((byte[])idPadded);
    }

    public byte[] getId() {
        byte[] id = new byte[7];
        System.arraycopy(this.blocks[0], 0, id, 0, 7);
        return id;
    }

    public void setId() {
        WorldDataRfidUniqueId worldDataRfidUniqueId = WorldDataRfidUniqueId.get();
        if (worldDataRfidUniqueId == null) {
            return;
        }
        long newId = (worldDataRfidUniqueId.getLastId() + 1L) % 0xFFFFFFFFFFFFFFL;
        worldDataRfidUniqueId.setLastId(newId);
        worldDataRfidUniqueId.func_76185_a();
        byte[] newIdBytes = Longs.toByteArray((long)newId);
        System.arraycopy(newIdBytes, 1, this.blocks[0], 0, 7);
    }

    public void setId(long id) {
        byte[] idBytes = Longs.toByteArray((long)id);
        System.arraycopy(idBytes, 1, this.blocks[0], 0, 7);
    }

    private NBTTagCompound writeToNbt(NBTTagCompound compound) {
        NBTTagList blockList = new NBTTagList();
        for (byte[] block : this.blocks) {
            blockList.func_74742_a((NBTBase)new NBTTagByteArray(block));
        }
        compound.func_74782_a("block_list", (NBTBase)blockList);
        return compound;
    }

    private void readFromNbt(NBTTagCompound compound) {
        NBTTagList blockList = compound.func_150295_c("block_list", 7);
        int blockIndex = 0;
        for (NBTBase blockBase : blockList) {
            NBTTagByteArray block = (NBTTagByteArray)blockBase;
            if (blockIndex >= this.blocks.length) break;
            this.blocks[blockIndex] = block.func_150292_c();
            ++blockIndex;
        }
    }

    @Nonnull
    public static ItemStack createChip(RfidTag tag) {
        ItemStack chip = new ItemStack(ModItems.RFID_CHIP);
        RfidTag.addTag(chip, tag);
        return chip;
    }

    public static boolean itemIdEquals(ItemStack item, byte[] id) {
        if (!RfidTag.hasTag(item)) {
            return false;
        }
        RfidTag rfidTag = new RfidTag(item);
        return Arrays.equals(rfidTag.getId(), id);
    }

    public byte[] getBlock(int block) {
        return (byte[])this.blocks[block].clone();
    }

    public void setBlock(byte[] blockData, int block) {
        this.blocks[block] = (byte[])blockData.clone();
    }

    public static void removeTag(ItemStack itemStack) {
        if (!RfidTag.hasTag(itemStack)) {
            return;
        }
        NBTTagCompound compound = itemStack.func_77978_p();
        assert (compound != null);
        compound.func_82580_o(RFID_TAG);
        if (compound.func_74764_b("display")) {
            NBTTagCompound display = compound.func_74775_l("display");
            if (display.func_74764_b("Lore")) {
                NBTTagList lore = display.func_150295_c("Lore", 8);
                int loreIndex = 0;
                for (NBTBase loreString : lore) {
                    if (((NBTTagString)loreString).func_150285_a_().equals(LORE_STRING)) {
                        lore.func_74744_a(loreIndex);
                        break;
                    }
                    ++loreIndex;
                }
                if (lore.func_74745_c() > 0) {
                    display.func_74782_a("Lore", (NBTBase)lore);
                } else {
                    display.func_82580_o("Lore");
                }
            }
            if (display.func_74764_b("Lore")) {
                compound.func_74782_a("display", (NBTBase)display);
            } else {
                compound.func_82580_o("display");
            }
        }
        if (compound.func_186856_d() > 0) {
            itemStack.func_77982_d(compound);
        } else {
            itemStack.func_77982_d(null);
        }
    }

    public static ItemStack createDummyCard(String name) {
        RfidTag tag = new RfidTag(ItemStack.field_190927_a);
        tag.setId(0xFFFFFFFFFFFFFFL);
        ItemStack rfidCard = new ItemStack(ModItems.PLASTIC_CARD);
        rfidCard.func_190924_f(name);
        ArrayList<String> info = new ArrayList<String>();
        info.add("Craft to generate a unique ID");
        NBTHelper.addInfo((ItemStack)rfidCard, info);
        RfidTag.addTag(rfidCard, tag);
        return rfidCard;
    }

    public static enum KeyType {
        A,
        B;

    }
}

