/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils.peripheralcontainer;

import com.austinv11.peripheralsplusplus.blocks.BlockPeripheralContainer;
import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ContainedPeripheral {
    private IPeripheral peripheral;
    private ResourceLocation blockResourceLocation;

    public ContainedPeripheral(ResourceLocation blockResourceLocation, IPeripheral peripheral) {
        this.blockResourceLocation = blockResourceLocation;
        this.peripheral = peripheral;
    }

    public ContainedPeripheral(NBTTagCompound tagCompound) {
        block2: {
            this.blockResourceLocation = new ResourceLocation(tagCompound.func_74779_i("id"));
            try {
                Class<?> clazz = Class.forName(tagCompound.func_74779_i("class"));
                this.peripheral = (IPeripheral)clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.peripheral = ContainedPeripheral.getPeripheralForBlock((Block)ForgeRegistries.BLOCKS.getValue(this.blockResourceLocation));
                if (!(this.peripheral instanceof TileEntity) || !tagCompound.func_74764_b("tileEntity")) break block2;
                ((TileEntity)this.peripheral).func_145839_a(tagCompound.func_74775_l("tileEntity"));
            }
        }
    }

    @Nullable
    public static IPeripheral getPeripheralForBlock(Block block) {
        if (!(block instanceof BlockPeripheralContainer)) {
            IPeripheral peripheral = null;
            if (block instanceof IPeripheral) {
                peripheral = (IPeripheral)block;
            }
            if (peripheral == null && block instanceof ITileEntityProvider) {
                TileEntity ent = null;
                try {
                    ent = block.createTileEntity(null, block.func_176223_P());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (ent != null && ent instanceof IPeripheral) {
                    peripheral = (IPeripheral)ent;
                }
            }
            return peripheral;
        }
        return null;
    }

    public ResourceLocation getBlockResourceLocation() {
        return this.blockResourceLocation;
    }

    public NBTTagCompound toNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("id", this.blockResourceLocation.toString());
        tag.func_74778_a("class", this.peripheral.getClass().toString());
        if (this.getPeripheral() instanceof TileEntity) {
            NBTTagCompound tileEntityTag = new NBTTagCompound();
            ((TileEntity)this.getPeripheral()).func_189515_b(tileEntityTag);
            tag.func_74782_a("tileEntity", (NBTBase)tileEntityTag);
        }
        return tag;
    }

    public IPeripheral getPeripheral() {
        return this.peripheral;
    }
}

