/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import dan200.computercraft.api.turtle.TurtleSide;
import java.util.Arrays;
import java.util.Locale;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ModelUtil {
    public static void registerTurtleUpgradeModels(IRegistry<ModelResourceLocation, IBakedModel> registry, String name) {
        String[] sides;
        for (String side : sides = new String[]{"left", "right"}) {
            ModelUtil.registerModel(registry, name + "_" + side, ModelType.BLOCK, "inventory");
        }
    }

    public static void registerModel(IRegistry<ModelResourceLocation, IBakedModel> registry, String name, ModelType modelType, String ... variants) {
        IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("peripheralsplusone", modelType.name().toLowerCase(Locale.US) + "/" + name), (String)String.format("Failed to load model: %s/%s with variants #%s", modelType.name().toLowerCase(Locale.US), name, Arrays.toString(variants)));
        IBakedModel bakedModel = model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, resourceLocation -> Minecraft.func_71410_x().func_147117_R().func_110572_b(resourceLocation.toString()));
        for (String variant : variants) {
            registry.func_82595_a((Object)new ModelResourceLocation("peripheralsplusone:" + name, variant), (Object)bakedModel);
        }
    }

    public static Pair<IBakedModel, Matrix4f> getTurtleUpgradeModel(String modelName, TurtleSide side) {
        return ModelUtil.getTurtleUpgradeModel(modelName, side, false);
    }

    public static Pair<IBakedModel, Matrix4f> getTurtleUpgradeModel(String modelName, TurtleSide side, boolean toolTransform) {
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        ModelResourceLocation modelResource = new ModelResourceLocation("peripheralsplusone:" + modelName + "_" + side.name().toLowerCase(Locale.US), "inventory");
        IBakedModel model = modelManager.func_174953_a(modelResource);
        Matrix4f transform = null;
        if (toolTransform) {
            float xOffset = side.equals((Object)TurtleSide.Left) ? -0.40625f : 0.40625f;
            transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        }
        return Pair.of((Object)model, transform);
    }

    public static enum ModelType {
        BLOCK,
        ITEM;

    }
}

