/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class PeripheralXP
implements IPlusPlusPeripheral {
    private static final int MAX_LEVEL = 30;
    private static final double COLLECT_RANGE = 2.0;
    private final BetterRandom random = new BetterRandom();
    private int experience = 0;
    private int experienceRemainder = 0;
    private int experienceLevel = 0;
    private boolean autoCollect = false;
    private int ticker = this.random.nextInt(20);
    public boolean changed = false;
    private ITurtleAccess turtle;
    private TurtleSide side;

    public PeripheralXP(ITurtleAccess turtleAccess, TurtleSide side) {
        this.turtle = turtleAccess;
        this.side = side;
        NBTTagCompound tag = this.turtle.getUpgradeNBTData(side);
        this.experience = tag.func_74762_e("experience");
        this.experienceRemainder = tag.func_74762_e("experienceRemainder");
        this.experienceLevel = tag.func_74762_e("experienceLevel");
        this.random.setSeed(tag.func_74763_f("rndSeed"));
    }

    public void update() {
        if (this.autoCollect && ++this.ticker >= 20) {
            this.ticker = 0;
            this.addExperience(this.collect());
            this.changed = true;
        }
        if (this.changed) {
            NBTTagCompound tag = this.turtle.getUpgradeNBTData(this.side);
            tag.func_74768_a("experience", this.experience);
            tag.func_74768_a("experienceRemainder", this.experienceRemainder);
            tag.func_74768_a("experienceLevel", this.experienceLevel);
            tag.func_74772_a("rndSeed", this.random.getSeed());
            this.turtle.updateUpgradeNBTData(this.side);
            this.changed = false;
        }
    }

    public void addExperience(int amount) {
        int var = Integer.MAX_VALUE - this.experience;
        if (amount > var) {
            amount = var;
        }
        this.experienceRemainder += amount;
        this.experience += amount;
        while (this.experienceRemainder < 0 || this.experienceRemainder >= this.levelXP(this.experienceLevel)) {
            this.addLevels(this.experienceRemainder < 0 ? -1 : 1, false);
            this.experienceRemainder -= this.levelXP(this.experienceLevel) * (this.experienceRemainder < 0 ? -1 : 1);
        }
    }

    public void addLevels(int par1, boolean updateXP) {
        this.experienceLevel += par1;
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
        }
        if (updateXP) {
            this.experience = this.calculateLevelXP(this.experienceLevel) + this.experienceRemainder;
        }
    }

    public int levelXP(int level) {
        return level >= 30 ? 62 + (level - 30) * 7 : (level >= 15 ? 17 + (level - 15) * 3 : 17);
    }

    public int calculateLevelXP(int level) {
        int levelXP = 0;
        for (int currentLevel = 1; currentLevel <= level; ++currentLevel) {
            levelXP += this.levelXP(currentLevel);
        }
        return levelXP;
    }

    private int collect() {
        int ret = 0;
        BlockPos pos = this.turtle.getPosition();
        List entities = this.turtle.getWorld().func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)pos.func_177958_n() - 2.0, (double)pos.func_177956_o() - 2.0, (double)pos.func_177952_p() - 2.0, (double)(pos.func_177958_n() + 1) + 2.0, (double)(pos.func_177956_o() + 1) + 2.0, (double)(pos.func_177952_p() + 1) + 2.0));
        for (EntityXPOrb orb : entities) {
            ret += orb.func_70526_d();
            orb.func_70106_y();
        }
        return ret;
    }

    public String getType() {
        return "xp";
    }

    public String[] getMethodNames() {
        return new String[]{"add", "getXP", "getLevels", "collect", "setAutoCollect", "enchant"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableXPTurtle) {
            throw new LuaException("XP Turtles have been disabled");
        }
        switch (method) {
            case 0: {
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                int amount = Integer.MAX_VALUE;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    amount = (int)Math.floor((Double)arguments[0]);
                }
                if (slot.func_190916_E() < 1) {
                    return new Object[]{0};
                }
                amount = Math.min(amount, slot.func_190916_E());
                int recharge = 0;
                if (slot.func_77969_a(new ItemStack(Items.field_151062_by))) {
                    recharge = 3 + this.random.nextInt(5) + this.random.nextInt(5);
                }
                this.addExperience(recharge *= amount);
                if (recharge > 0) {
                    slot.func_190920_e(slot.func_190916_E() - amount);
                    if (slot.func_190916_E() <= 0) {
                        slot = ItemStack.field_190927_a;
                    }
                    this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), slot);
                }
                this.changed = true;
                return new Object[]{recharge};
            }
            case 1: {
                return new Object[]{this.experience};
            }
            case 2: {
                return new Object[]{this.experienceLevel};
            }
            case 3: {
                int collected = this.collect();
                this.addExperience(collected);
                this.changed = true;
                return new Object[]{collected};
            }
            case 4: {
                boolean ac;
                boolean bl = ac = !this.autoCollect;
                if (arguments.length > 0) {
                    if (!(arguments[0] instanceof Boolean)) {
                        throw new LuaException("Bad argument #1 (expected boolean)");
                    }
                    ac = (Boolean)arguments[0];
                }
                this.autoCollect = ac;
                return new Object[]{this.autoCollect};
            }
            case 5: {
                if (arguments.length < 1) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                int levels = (int)Math.floor((Double)arguments[0]);
                if (levels < 1 || levels > 30) {
                    throw new LuaException("invalid level count " + levels + " (expected 1-" + 30 + ")");
                }
                ItemStack slot = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                if (!slot.func_77956_u()) {
                    return new Object[]{false};
                }
                if (this.experienceLevel < levels) {
                    return new Object[]{false};
                }
                List enchants = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)slot, (int)levels, (boolean)true);
                if (enchants.isEmpty()) {
                    return new Object[]{false};
                }
                ItemStack enchanted = slot.func_77946_l();
                if (enchanted.func_77969_a(new ItemStack(Items.field_151122_aG))) {
                    enchanted = new ItemStack(Items.field_151134_bR);
                    enchanted.func_77982_d(new NBTTagCompound());
                    NBTTagList storedEnchantments = new NBTTagList();
                    NBTTagCompound enchantment = new NBTTagCompound();
                    EnchantmentData data = (EnchantmentData)enchants.get(0);
                    enchantment.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)data.field_76302_b));
                    enchantment.func_74777_a("lvl", (short)data.field_76303_c);
                    storedEnchantments.func_74742_a((NBTBase)enchantment);
                    enchanted.func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)storedEnchantments);
                } else {
                    for (EnchantmentData data : enchants) {
                        enchanted.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
                this.addLevels(-levels, true);
                this.turtle.getInventory().func_70299_a(this.turtle.getSelectedSlot(), enchanted);
                this.changed = true;
                return new Object[]{true};
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }

    private class BetterRandom
    extends Random {
        private long seed;

        private BetterRandom() {
        }

        @Override
        public void setSeed(long seed) {
            super.setSeed(seed);
            this.seed = seed;
        }

        public long getSeed() {
            return this.seed;
        }
    }
}

