/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.blocks.BlockResupplyStation;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.TileEntityResupplyStation;
import com.austinv11.peripheralsplusplus.utils.IPlusPlusPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PeripheralResupply
implements IPlusPlusPeripheral {
    private ITurtleAccess turtle;
    private BlockPos linkedStation;

    public PeripheralResupply(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "resupply";
    }

    public String[] getMethodNames() {
        return new String[]{"link", "resupply"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableResupplyStation) {
            throw new LuaException("The resupply station has been disabled");
        }
        switch (method) {
            case 0: {
                if (arguments.length < 1 || arguments.length > 1 && arguments.length < 3) {
                    throw new LuaException("Too few arguments");
                }
                if (!(arguments[0] instanceof String) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected string or number)");
                }
                if (arguments.length > 1) {
                    if (!(arguments[0] instanceof Double)) {
                        throw new LuaException("Bad argument #1 (expected number)");
                    }
                    if (!(arguments[1] instanceof Double)) {
                        throw new LuaException("Bad argument #2 (expected number)");
                    }
                    if (!(arguments[2] instanceof Double)) {
                        throw new LuaException("Bad argument #3 (expected number)");
                    }
                    this.linkedStation = new BlockPos(((Double)arguments[0]).intValue(), ((Double)arguments[1]).intValue(), ((Double)arguments[2]).intValue());
                    return new Object[]{true};
                }
                EnumFacing dir = arguments[0] instanceof String ? EnumFacing.valueOf((String)((String)arguments[0]).toUpperCase()) : EnumFacing.func_82600_a((int)((int)((Double)arguments[0]).doubleValue()));
                BlockPos newLink = this.turtle.getPosition().func_177972_a(dir);
                World turtleWorld = this.turtle.getWorld();
                if (turtleWorld.func_175623_d(newLink) || !(turtleWorld.func_180495_p(newLink).func_177230_c() instanceof BlockResupplyStation)) {
                    return new Object[]{false};
                }
                this.linkedStation = newLink;
                return new Object[]{true};
            }
            case 1: {
                ResourceLocation id;
                if (this.linkedStation == null) {
                    throw new LuaException("A station has not been linked!");
                }
                World world = this.turtle.getWorld();
                if (world.func_175623_d(this.linkedStation) || !(world.func_180495_p(this.linkedStation).func_177230_c() instanceof BlockResupplyStation)) {
                    throw new LuaException("The linked station is nonexistant!");
                }
                if (arguments.length > 0 && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Bad argument #1 (expected number)");
                }
                if (arguments.length > 1 && !(arguments[1] instanceof String) && !(arguments[1] instanceof Double)) {
                    throw new LuaException("Bad argument #2 (expected string or number)");
                }
                if (arguments.length > 2 && !(arguments[2] instanceof Double)) {
                    throw new LuaException("Bad argument #3 (expected number)");
                }
                int slot = this.turtle.getSelectedSlot();
                if (arguments.length > 0) {
                    slot = ((Double)arguments[0]).intValue() - 1;
                }
                if (arguments.length > 1 && arguments[1] instanceof String) {
                    id = new ResourceLocation((String)arguments[1]);
                } else {
                    if (this.turtle.getInventory().func_70301_a(slot).func_190926_b()) {
                        return new Object[]{false};
                    }
                    if (this.turtle.getInventory().func_70301_a(slot).func_77973_b() instanceof ItemBlock) {
                        Block itemBlock = Block.func_149634_a((Item)this.turtle.getInventory().func_70301_a(slot).func_77973_b());
                        id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)itemBlock);
                    } else {
                        Item item = this.turtle.getInventory().func_70301_a(slot).func_77973_b();
                        id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
                    }
                }
                int meta = arguments.length > 2 ? ((Double)arguments[2]).intValue() : (this.turtle.getInventory().func_70301_a(slot).func_190926_b() ? 0 : this.turtle.getInventory().func_70301_a(slot).func_77952_i());
                PeripheralResupply peripheralResupply = this;
                synchronized (peripheralResupply) {
                    TileEntityResupplyStation station = (TileEntityResupplyStation)world.func_175625_s(this.linkedStation);
                    if (station != null) {
                        return new Object[]{station.resupply(this.turtle, slot, id, meta)};
                    }
                    break;
                }
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }
}

