/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles;

import com.austinv11.collectiveframework.minecraft.utils.ModelManager;
import com.austinv11.collectiveframework.minecraft.utils.TextureManager;
import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.utils.ModelUtil;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleRidable
implements ITurtleUpgrade,
TextureManager.TextureRegistrar,
ModelManager.ModelRegistrar {
    @Nonnull
    public ResourceLocation getUpgradeID() {
        return new ResourceLocation("peripheralsplusone:ridable");
    }

    public int getLegacyUpgradeID() {
        return 130;
    }

    public String getUnlocalisedAdjective() {
        return "peripheralsplusone.turtle_upgrade.ridable";
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    public ItemStack getCraftingItem() {
        if (Config.enableRidableTurtle) {
            return new ItemStack(Items.field_151141_av);
        }
        return ItemStack.field_190927_a;
    }

    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        EntityRidableTurtle entity = new EntityRidableTurtle(turtle.getWorld());
        entity.func_70107_b(turtle.getPosition().func_177958_n(), turtle.getPosition().func_177956_o(), turtle.getPosition().func_177952_p());
        entity.setTurtle(turtle);
        turtle.getWorld().func_72838_d((Entity)entity);
        return entity;
    }

    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        return TurtleCommandResult.failure();
    }

    public void update(ITurtleAccess turtle, TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof EntityRidableTurtle) {
            ((EntityRidableTurtle)peripheral).update(turtle);
        }
    }

    @Nonnull
    public Pair<IBakedModel, Matrix4f> getModel(@Nullable ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return ModelUtil.getTurtleUpgradeModel("turtle_ridable", side);
    }

    public void registerModels(IRegistry<ModelResourceLocation, IBakedModel> registry) {
        ModelUtil.registerTurtleUpgradeModels(registry, "turtle_ridable");
    }

    public void registerTextures(TextureMap textureMap) {
        textureMap.func_174942_a(new ResourceLocation("peripheralsplusone", "blocks/ridable_turtle_upgrade"));
    }
}

